/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client;

import java.io.File;
import java.net.URL;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

public enum GcRestClientConfigOption implements ConfigOptionDef
{
    CONFIG_FILE(String.class, "config.file", "Configuration filename", "gc.conf", true, false),
    BUILD_VERSION(Version.class, "gc.build.version", "gc.build.version.description", null, true, false),
    BUILD_DATE(String.class, "gc.build.date", "gc.build.date.description", null, true, false),
    BUILD_NUMBER(String.class, "gc.build.number", "gc.build.number.description", null, true, false),
    API_URL(URL.class, "gc.rest.apiUrl", "gc.rest.apiUrl", "https://demo.ultreia.io/gc-rest-api${gc.classifier}/v1", true, false),
    CLASSIFIER(String.class, "gc.classifier", "Instance classifier", "-stable", false, false),
    DATA_DIRECTORY(File.class, "gc.dataDirectory", "Data directory", "${user.home}/.gc", false, false),
    TEMPORARY_DIRECTORY(File.class, "gc.temporaryDirectory", "gc.temporaryDirectory.description", "${gc.baseDirectory}/temp", true, false),
    LOGIN(String.class, "gc.auth.login", "Geocaching.com login", null, false, false),
    PASSWORD(String.class, "gc.auth.password", "Geocaching.com password", null, false, false);

    private final Class type;
    private final String key;
    private final String description;
    private String defaultValue;
    private boolean _transient;
    private boolean _final;

    private GcRestClientConfigOption(Class type, String key, String description, String defaultValue, boolean _transient, boolean _final) {
        this.type = type;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this._final = _final;
        this._transient = _transient;
    }

    public String getKey() {
        return this.key;
    }

    public Class getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }
}

