/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client;

import io.ultreia.gc.config.GcConfig;
import io.ultreia.gc.db.entity.GcCountry;
import io.ultreia.gc.http.GcExecuteRequestException;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.http.GcResponseBuilder;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.rest.client.GcRestClientConfig;
import io.ultreia.gc.service.api.GcLogService;
import io.ultreia.gc.service.api.GcSearchFilter;
import io.ultreia.gc.service.api.GcService;
import io.ultreia.gc.service.internal.GcCacheServiceImpl;
import io.ultreia.gc.service.internal.GpxServiceImpl;
import io.ultreia.gc.ui.GcApplicationContextSupport;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GcRestClientApplicationContext
extends GcApplicationContextSupport<GcRestClientConfig> {
    private static final Log log = LogFactory.getLog(GcRestClientApplicationContext.class);
    private final GcResponseBuilder responseBuilder = GcResponseBuilder.create();

    public GcRestClientApplicationContext(GcRestClientConfig config) {
        super((GcConfig)config);
    }

    boolean withAuthId() {
        return this.getAuthId().isPresent();
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            try {
                this.responseBuilder.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close response builder", (Throwable)e);
            }
        }
    }

    public <S extends GcService> Class<S> getServiceClass(Class<S> serviceType) {
        if (!serviceType.isInterface() && !Modifier.isAbstract(serviceType.getModifiers())) {
            return serviceType;
        }
        try {
            return Class.forName(serviceType.getName().replace("service.api", "rest.client.v1") + "RestClient");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    GcResponse executeRequest(GcRequest request, int expectedStatusCode) {
        try {
            return this.responseBuilder.executeRequest(request, expectedStatusCode);
        }
        catch (IOException e) {
            throw new GcExecuteRequestException((Exception)e);
        }
    }

    GcResponse executeRequest(GcRequest request) {
        try {
            return this.responseBuilder.executeRequest(request);
        }
        catch (IOException e) {
            throw new GcExecuteRequestException((Exception)e);
        }
    }

    public static void captureScreen(Path fileName) throws IOException, AWTException {
        Rectangle screenRectangle = new Rectangle(0, 0, 100, 300);
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(screenRectangle);
        ImageIO.write((RenderedImage)image, "png", fileName.toFile());
    }

    public static void main(String[] args) throws IOException, AWTException, IllegalAccessException, InstantiationException, InvocationTargetException {
        GcRestClientConfig clientConfig = GcRestClientConfig.create(args);
        clientConfig.get().doAllAction();
        GcRestClientApplicationContext applicationContext = new GcRestClientApplicationContext(clientConfig);
        String authId = applicationContext.newLoginService().login(clientConfig.getLogin(), clientConfig.getPassword());
        applicationContext.setAuthId(authId);
        log.info((Object)("log in: " + authId));
        GcSearchFilter filter = new GcSearchFilter();
        filter.country = GcCountry.Madagascar.code();
        GcLogService logService = applicationContext.newLogService();
        Optional myArcheoLogFromGcName = logService.getMyArcheoLogFromGcName("GC60JWK", "akrtan");
        log.info((Object)myArcheoLogFromGcName);
    }

    static List<GcCache> loadMyFinds(Path gpxPath, Path myDbPath) throws IOException {
        List caches;
        if (!Files.exists(myDbPath, new LinkOption[0]) || Files.getLastModifiedTime(myDbPath, new LinkOption[0]).compareTo(Files.getLastModifiedTime(gpxPath, new LinkOption[0])) < 0) {
            log.info((Object)("Loading gpx " + gpxPath));
            caches = new GpxServiceImpl().getCaches(gpxPath.toFile());
            log.info((Object)("Load " + caches.size() + " cache(s)."));
            new GcCacheServiceImpl().storeCaches(caches, myDbPath.toFile());
        } else {
            log.info((Object)("Loading json " + myDbPath));
            caches = new GcCacheServiceImpl().loadCaches(myDbPath.toFile());
            log.info((Object)("Load " + caches.size() + " cache(s)."));
        }
        return caches;
    }
}

