/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.v1;

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.LoginService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginServiceRestClient
extends GcRestClientServiceSupport
implements LoginService {
    private static final Log log = LogFactory.getLog(LoginServiceRestClient.class);

    public String login(String login, String password) {
        GcRequest request = this.forGet("login").addParameter("login", login).addParameter("password", password).build();
        String authenticationToken = this.executeRequest(request).toString().replaceAll("\"", "");
        log.info((Object)String.format("for login: %s - authentication token: %s", login, authenticationToken));
        this.getApplicationContext().setAuthId(authenticationToken);
        return authenticationToken;
    }

    public void logout() {
        String authenticationToken = (String)this.getApplicationContext().getAuthId().orElseThrow(IllegalStateException::new);
        log.info((Object)String.format("for logout - authentication token: %s", authenticationToken));
        GcRequest request = this.forGet("logout").build();
        this.executeRequest(request);
        this.getApplicationContext().setAuthId(null);
    }
}

