/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.v1;

import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.model.GcArcheoLog;
import io.ultreia.gc.model.GcLog;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.GcLogService;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;

public class GcLogServiceRestClient
extends GcRestClientServiceSupport
implements GcLogService {
    public void loadLogs() {
        GcRequest request = this.forPost("loadLogs").addAuthToken().setTimeout(86400000).build();
        this.executeRequest(request);
    }

    public List<GcLog> getLogsFromGcName(String gcName) {
        GcRequest request = this.forGet("gc/" + gcName + "/logs").addAuthToken().build();
        Type type = new TypeToken<List<GcLog>>(){}.getType();
        return (List)this.executeRequest(request).toJson(type);
    }

    public void deleteLogsForGcName(String gcName) {
        GcRequest request = this.forDelete("gc/" + gcName + "/logs").addAuthToken().build();
        this.executeRequest(request);
    }

    public Optional<GcArcheoLog> getMyArcheoLogFromGcName(String gcName, String username) {
        GcRequest request = this.forGet("gc/" + gcName + "/archeo").addAuthToken().addParameter("username", username).build();
        Type type = new TypeToken<Optional<GcArcheoLog>>(){}.getType();
        return (Optional)this.executeRequest(request).toJson(type);
    }
}

