/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client;

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.rest.client.GcRestClientApplicationContext;
import io.ultreia.gc.rest.client.GcRestClientConfig;
import io.ultreia.gc.service.api.GcServiceContext;
import io.ultreia.gc.service.internal.GcServiceSupport;
import io.ultreia.gc.session.GcSession;

public abstract class GcRestClientServiceSupport
extends GcServiceSupport {
    private String apiUrl;

    public void setServiceContext(GcServiceContext serviceContext) {
        super.setServiceContext(serviceContext);
        GcRestClientConfig config = (GcRestClientConfig)this.getApplicationContext().getConfig();
        this.apiUrl = config.getApiUrl().toExternalForm();
        if (!this.apiUrl.endsWith("/")) {
            this.apiUrl = this.apiUrl + "/";
        }
    }

    protected GcRestClientApplicationContext getApplicationContext() {
        return (GcRestClientApplicationContext)this.serviceContext;
    }

    public GcRequestBuilder forGet(String baseUrl) {
        GcRequestBuilder requestBuilder = GcRequestBuilder.forGet((String)(this.apiUrl + baseUrl), this::getAuthenticationToken);
        this.addAuthId(requestBuilder);
        return requestBuilder.setTimeout(3600000);
    }

    private String getAuthenticationToken() {
        return this.serviceContext.getAuthId().orElse(null);
    }

    public GcRequestBuilder forPost(String baseUrl) {
        GcRequestBuilder requestBuilder = GcRequestBuilder.forPost((String)(this.apiUrl + baseUrl), this::getAuthenticationToken);
        this.addAuthId(requestBuilder);
        return requestBuilder.setTimeout(3600000);
    }

    public GcRequestBuilder forDelete(String baseUrl) {
        GcRequestBuilder requestBuilder = GcRequestBuilder.forDelete((String)(this.apiUrl + baseUrl), this::getAuthenticationToken);
        this.addAuthId(requestBuilder);
        return requestBuilder.setTimeout(3600000);
    }

    public GcResponse executeRequest(GcRequest request) {
        return this.getApplicationContext().executeRequest(request);
    }

    public GcResponse executeRequest(GcRequest request, int expectedStatusCode) {
        GcResponse gcResponse = this.getApplicationContext().executeRequest(request);
        GcSession.checkStatusCode((GcResponse)gcResponse, (int)expectedStatusCode);
        return gcResponse;
    }

    private void addAuthId(GcRequestBuilder requestBuilder) {
        if (this.getApplicationContext().withAuthId()) {
            requestBuilder.addAuthToken();
        }
    }
}

