/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.config.GcConfig;
import io.ultreia.gc.http.GcExecuteRequestException;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.http.GcResponseBuilder;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.rest.client.GcRestClientConfig;
import io.ultreia.gc.service.api.GcCacheService;
import io.ultreia.gc.service.api.GcLogService;
import io.ultreia.gc.service.api.GcService;
import io.ultreia.gc.service.internal.GcCacheServiceImpl;
import io.ultreia.gc.service.internal.GpxServiceImpl;
import io.ultreia.gc.ui.GcApplicationContextSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GcRestClientApplicationContext
extends GcApplicationContextSupport<GcRestClientConfig> {
    private static final Log log = LogFactory.getLog(GcRestClientApplicationContext.class);
    private static GcRestClientApplicationContext INSTANCE;
    private final GcResponseBuilder responseBuilder = GcResponseBuilder.create();

    public static GcRestClientApplicationContext create(GcRestClientConfig config) {
        INSTANCE = new GcRestClientApplicationContext(config);
        return INSTANCE;
    }

    static GcRestClientApplicationContext get() {
        return INSTANCE;
    }

    private GcRestClientApplicationContext(GcRestClientConfig config) {
        super((GcConfig)config);
    }

    boolean withAuthId() {
        return this.getAuthId().isPresent();
    }

    protected <S extends GcService> Class<S> getServiceClass(Class<S> serviceType) {
        if (!serviceType.isInterface() && !Modifier.isAbstract(serviceType.getModifiers())) {
            return serviceType;
        }
        try {
            return Class.forName(serviceType.getName().replace("service.api", "rest.client.v1") + "RestClient");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    GcResponse executeRequest(GcRequest request) {
        try {
            return this.responseBuilder.executeRequest(request);
        }
        catch (IOException e) {
            throw new GcExecuteRequestException((Exception)e);
        }
    }

    public static void main(String[] args) throws IOException {
        GcRestClientConfig clientConfig = GcRestClientConfig.create(args);
        GcRestClientApplicationContext applicationContext = GcRestClientApplicationContext.create(clientConfig);
        String authId = applicationContext.newLoginService().login(clientConfig.getLogin(), clientConfig.getPassword());
        log.info((Object)("log in: " + authId));
        applicationContext.newLogService().loadLogs();
    }

    static List<GcCache> loadMyFinds(Path gpxPath, Path myDbPath) throws IOException {
        List caches;
        if (!Files.exists(myDbPath, new LinkOption[0]) || Files.getLastModifiedTime(myDbPath, new LinkOption[0]).compareTo(Files.getLastModifiedTime(gpxPath, new LinkOption[0])) < 0) {
            log.info((Object)("Loading gpx " + gpxPath));
            caches = new GpxServiceImpl().getCaches(gpxPath.toFile());
            log.info((Object)("Load " + caches.size() + " cache(s)."));
            new GcCacheServiceImpl().storeCaches(caches, myDbPath.toFile());
        } else {
            log.info((Object)("Loading json " + myDbPath));
            caches = new GcCacheServiceImpl().loadCaches(myDbPath.toFile());
            log.info((Object)("Load " + caches.size() + " cache(s)."));
        }
        return caches;
    }

    static void loadLogs(GcApiConfig config, GcRestClientApplicationContext applicationContext) throws IOException {
        List gcNames;
        MutableInt i = new MutableInt();
        GcCacheService cacheService = applicationContext.newCacheService();
        GcLogService logService = applicationContext.newLogService();
        Path path = config.getDataDirectory().toPath().resolve("gcnames.json");
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader writer = Files.newBufferedReader(path);){
                Type type = new TypeToken<List<String>>(){}.getType();
                gcNames = (List)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)writer, type);
            }
        }
        gcNames = new LinkedList(cacheService.getGcNames());
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson(gcNames, (Appendable)writer);
        }
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "20");
        gcNames.sort(String::compareTo);
        Collections.reverse(gcNames);
        gcNames.parallelStream().forEach(gcName -> {
            try {
                log.info((Object)String.format("%d/%d : %s", i.incrementAndGet(), gcNames.size(), gcName));
                GcCache cache = cacheService.getCacheFromGcName(gcName);
                List logsFromGcName = logService.getLogsFromGcName(gcName);
                log.info((Object)String.format("%d/%d : %s - %d", i.getValue(), gcNames.size(), cache.getGcName(), logsFromGcName.size()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

