package io.ultreia.gc.rest.client.v1;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.LoginService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by tchemit on 26/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class LoginServiceRestClient extends GcRestClientServiceSupport implements LoginService {

    /** Logger. */
    private static final Log log = LogFactory.getLog(LoginServiceRestClient.class);

    public String login(String login, String password) {

        GcRequest request = forGet("login")
                .addParameter("login", login)
                .addParameter("password", password)
                .build();
        String authenticationToken = executeRequest(request).toString().replaceAll("\"", "");
        log.info(String.format("for login: %s - authentication token: %s", login, authenticationToken));
        getApplicationContext().setAuthId(authenticationToken);
        return authenticationToken;
    }

    public void logout() {
        String authenticationToken = getApplicationContext().getAuthId().orElseThrow(IllegalStateException::new);
        log.info(String.format("for logout - authentication token: %s", authenticationToken));
        GcRequest request = forGet("logout").build();
        executeRequest(request);
        getApplicationContext().setAuthId(null);
    }

}
