package io.ultreia.gc.rest.client.v1;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.model.GcArcheoLog;
import io.ultreia.gc.model.GcLog;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.GcLogService;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;

/**
 * Created by tchemit on 26/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcLogServiceRestClient extends GcRestClientServiceSupport implements GcLogService {

    @Override
    public void loadLogs() {
        GcRequest request = forPost("loadLogs").addAuthToken().setTimeout(24 * 60 * 60 * 1000).build();
        executeRequest(request);
    }

    @Override
    public List<GcLog> getLogsFromGcName(String gcName) {

        GcRequest request = forGet("gc/" + gcName + "/logs").addAuthToken().build();

        Type type = new TypeToken<List<GcLog>>() {
        }.getType();

        return executeRequest(request).toJson(type);

    }

    @Override
    public void deleteLogsForGcName(String gcName) {

        GcRequest request = forDelete("gc/" + gcName + "/logs").addAuthToken().build();
        executeRequest(request);
    }

    @Override
    public Optional<GcArcheoLog> getMyArcheoLogFromGcName(String gcName, String username) {

        GcRequest request = forGet("gc/" + gcName + "/archeo")
                .addAuthToken()
                .addParameter("username", username).build();
        Type type = new TypeToken<Optional<GcArcheoLog>>() {
        }.getType();

        return executeRequest(request).toJson(type);

    }
}
