package io.ultreia.gc.rest.client.v1;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.GcCacheService;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpStatus;

/**
 * Created by tchemit on 26/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcCacheServiceRestClient extends GcRestClientServiceSupport implements GcCacheService {

    @Override
    public GcCache getCacheFromGcName(String gcName) {

        GcRequest request = forGet("gc/" + gcName).build();
        return executeRequest(request).toJson(GcCache.class);

    }

    @Override
    public void storeCache(GcCache cache) {
        String cacheForm = new GsonBuilder().create().toJson(cache);

        GcRequest request = forPost("gc/" + cache.getGcName()).addParameter("cache", cacheForm).build();
        executeRequest(request, HttpStatus.SC_OK);
    }

    @Override
    public List<String> getGcNames() {
        GcRequest request = forGet("gcnames").build();
        Type type = new TypeToken<Set<String>>(){}.getType();
        return executeRequest(request, HttpStatus.SC_OK).toJson(type);
    }

    @Override
    public List<String> getGcNamesWithoutLogs() {
        GcRequest request = forGet("gcnamesWithoutLogs").build();
        Type type = new TypeToken<Set<String>>(){}.getType();
        return executeRequest(request, HttpStatus.SC_OK).toJson(type);
    }

    @Override
    public List<GcCache> searchCaches(GcSearchFilter filter) {
        //TODO
        return null;
    }

    @Override
    public void getCacheFromGuid(String guid) {
        //TODO
    }

    @Override
    public GcCache getCacheRefFromGcName(String gcName) {
        //TODO
        return null;
    }
}
