package io.ultreia.gc.rest.client.v1;

/*-
 * #%L
 * GC toolkit :: REST Client
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.model.GcFieldNote;
import io.ultreia.gc.model.GcLogDraft;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.FieldNotesService;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.http.HttpStatus;

/**
 * Created by tchemit on 05/05/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class FieldNotesServiceRestClient extends GcRestClientServiceSupport implements FieldNotesService {

    private static final Type TYPE = new TypeToken<List<GcFieldNote>>() {
    }.getType();

    @Override
    public List<GcFieldNote> loadFieldNotes() {
        return executeRequest(forGet("fieldnotes").addAuthToken().build(), HttpStatus.SC_OK).toJson(TYPE);
    }

    @Override
    public void logFieldNote(GcFieldNote fieldNote, String logText, boolean autoVisitTrackables) {

        executeRequest(forPost("fieldnotes")
                               .addAuthToken()
                               .addParameter("fieldNote", new GsonBuilder().create().toJson(fieldNote))
                               .addParameter("logText", logText)
                               .addParameter("autoVisitTrackables", autoVisitTrackables)
                               .useMultiPartForm()
                               .build(), HttpStatus.SC_OK);

    }

    @Override
    public GcLogDraft getLogDraft(String referenceCode) {
        return executeRequest(forGet("logdraft")
                                      .addAuthToken()
                                      .addParameter("referenceCode", referenceCode)
                                      .build(), HttpStatus.SC_OK).toJson(GcLogDraft.class);
    }
}
