package io.ultreia.gc.rest.client;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Generated;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.version.Version;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Sat May 06 08:45:18 UTC 2017")
public abstract class GeneratedGcRestClientConfig implements Supplier<ApplicationConfig> {

    private ApplicationConfig applicationConfig;

    protected GeneratedGcRestClientConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedGcRestClientConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions(GcRestClientConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public Version getBuildVersion() {
        return applicationConfig.getOptionAsVersion(GcRestClientConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {    setOption(GcRestClientConfigOption.BUILD_VERSION.getKey(), buildVersion);
    }

    public String getBuildDate() {
        return applicationConfig.getOption(GcRestClientConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {    setOption(GcRestClientConfigOption.BUILD_DATE.getKey(), buildDate);
    }

    public String getBuildNumber() {
        return applicationConfig.getOption(GcRestClientConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {    setOption(GcRestClientConfigOption.BUILD_NUMBER.getKey(), buildNumber);
    }

    public URL getApiUrl() {
        return applicationConfig.getOptionAsURL(GcRestClientConfigOption.API_URL.getKey());
    }

    public void setApiUrl(URL apiUrl) {    setOption(GcRestClientConfigOption.API_URL.getKey(), apiUrl);
    }

    public File getDataDirectory() {
        return applicationConfig.getOptionAsFile(GcRestClientConfigOption.DATA_DIRECTORY.getKey());
    }

    public void setDataDirectory(File dataDirectory) {    setOption(GcRestClientConfigOption.DATA_DIRECTORY.getKey(), dataDirectory);
    }

    public String getLogin() {
        return applicationConfig.getOption(GcRestClientConfigOption.LOGIN.getKey());
    }

    public void setLogin(String login) {    setOption(GcRestClientConfigOption.LOGIN.getKey(), login);
    }

    public String getPassword() {
        return applicationConfig.getOption(GcRestClientConfigOption.PASSWORD.getKey());
    }

    public void setPassword(String password) {    setOption(GcRestClientConfigOption.PASSWORD.getKey(), password);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", get().getConfigFileName()));
        for (GcRestClientConfigOption option : orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcRestClientConfigOption> orderedByKey() {
        List<GcRestClientConfigOption> values = Arrays.asList(GcRestClientConfigOption.values());
        Collections.sort(values, new Comparator<GcRestClientConfigOption>() {
            @Override
            public int compare(GcRestClientConfigOption o1, GcRestClientConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }

} //GeneratedGcRestClientConfig
