package io.ultreia.gc.rest.client;

/*-
 * #%L
 * GC toolkit :: REST Client
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import javax.annotation.Generated;
import org.nuiton.config.ConfigOptionDef;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Sat May 06 08:45:16 UTC 2017")

public enum GcRestClientConfigOption implements ConfigOptionDef {
    
    BUILD_VERSION(
        org.nuiton.version.Version.class,
        "gc.build.version",
        "gc.build.version.description",
        null,
        true,
        false),
    
    BUILD_DATE(
        java.lang.String.class,
        "gc.build.date",
        "gc.build.date.description",
        null,
        true,
        false),
    
    BUILD_NUMBER(
        java.lang.String.class,
        "gc.build.number",
        "gc.build.number.description",
        null,
        true,
        false),
    
    API_URL(
        java.net.URL.class,
        "gc.rest.apiUrl",
        "gc.rest.apiUrl",
        "https://demo.ultreia.io/gc-rest-api-${gc.build.version}/v1",
        true,
        false),
    
    DATA_DIRECTORY(
        java.io.File.class,
        "gc.dataDirectory",
        "Data directory",
        "${user.home}/.gc",
        false,
        false),
    
    LOGIN(
        java.lang.String.class,
        "gc.auth.login",
        "Geocaching.com login",
        null,
        false,
        false),
    
    PASSWORD(
        java.lang.String.class,
        "gc.auth.password",
        "Geocaching.com password",
        null,
        false,
        false);

    private final Class type;

    private final String key;

    private final String description;

    private String defaultValue;

    private boolean _transient;

    private boolean _final;

    GcRestClientConfigOption(Class type, String key, String description, String defaultValue, boolean _transient, boolean _final) {
        this.type = type;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this._final = _final;
        this._transient = _transient;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isTransient() {
        return _transient;
    }

    @Override
    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    @Override
    public boolean isFinal() {
        return _final;
    }

    @Override
    public void setFinal(boolean _final) {
        this._final = _final;
    }

} //GcRestClientConfigOption
