/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api;

import com.google.common.base.Preconditions;
import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.db.entity.GcDbTopiaApplicationContext;
import io.ultreia.gc.rest.api.GcRestApiApplicationContext;
import io.ultreia.gc.rest.api.GcRestApiConfig;
import io.ultreia.gc.rest.api.internal.GcDtoGsonSupplier;
import io.ultreia.gc.rest.api.internal.GcRestApiApplicationListener;
import io.ultreia.gc.session.GcSessionsStore;
import java.io.Closeable;
import java.util.Objects;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.HttpContext;

public class GcRestApiApplicationContext
implements Closeable {
    public static final String APPLICATION_CONTEXT_PARAMETER = GcRestApiApplicationContext.class.getName();
    private static final String MISSING_APPLICATION_CONTEXT = GcRestApiApplicationContext.class.getSimpleName() + " not found. You probably forgot to register " + GcRestApiApplicationListener.class.getName() + " in your web.xml";
    private static final Log log = LogFactory.getLog(GcRestApiApplicationContext.class);
    private GcDtoGsonSupplier gsonSupplier;
    private GcRestApiConfig config;
    private GcApiConfig serviceConfig;
    private final GcRestApiSessions sessions = new GcRestApiSessions();
    private GcDbTopiaApplicationContext dbApplicationContext;

    public static GcRestApiApplicationContext getApplicationContext(HttpContext context) {
        ServletContext servletContext = context.getServletContext();
        GcRestApiApplicationContext result = (GcRestApiApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)MISSING_APPLICATION_CONTEXT);
        return result;
    }

    public void init(String contextPath) {
        log.info((Object)String.format("Init application classifier (%s)", contextPath));
        this.config = new GcRestApiConfig(contextPath, new String[0]);
        this.dbApplicationContext = GcDbTopiaApplicationContext.create((String)this.config.getClassifier(), (String[])new String[0]);
        boolean devMode = this.config.isDevMode();
        this.gsonSupplier = new GcDtoGsonSupplier(devMode);
        this.serviceConfig = new GcApiConfig();
        this.serviceConfig.setDataDirectory(this.config.getBaseDirectory());
        this.serviceConfig.setBuildDate(this.config.getBuildDate());
        this.serviceConfig.setBuildVersion(this.config.getBuildVersion());
        this.serviceConfig.setBuildNumber(this.config.getBuildNumber());
        this.serviceConfig.setClassifier(this.config.getClassifier());
        String neutralLogin = this.config.getNeutralLogin();
        Objects.requireNonNull(neutralLogin);
        String neutralPassword = this.config.getNeutralPassword();
        Objects.requireNonNull(neutralPassword);
        GcSessionsStore.get().initNeutral(neutralLogin, neutralPassword);
    }

    public GcDbTopiaApplicationContext getDbApplicationContext() {
        return this.dbApplicationContext;
    }

    @Override
    public void close() {
        try {
            this.sessions.close();
        }
        finally {
            this.dbApplicationContext.close();
        }
    }

    public GcDtoGsonSupplier getGsonSupplier() {
        return this.gsonSupplier;
    }

    public GcRestApiConfig getConfig() {
        return this.config;
    }

    public GcRestApiSessions getSessions() {
        return this.sessions;
    }

    public GcApiConfig getServiceConfig() {
        return this.serviceConfig;
    }
}

