/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api;

import io.ultreia.gc.rest.api.GcRestApiConfigOption;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

public abstract class GeneratedGcRestApiConfig
implements Supplier<ApplicationConfig> {
    private ApplicationConfig applicationConfig;

    protected GeneratedGcRestApiConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedGcRestApiConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])GcRestApiConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return this.applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getConfigFile() {
        return this.applicationConfig.getOption(GcRestApiConfigOption.CONFIG_FILE.getKey());
    }

    public void setConfigFile(String configFile) {
        this.setOption(GcRestApiConfigOption.CONFIG_FILE.getKey(), (Object)configFile);
    }

    public Version getBuildVersion() {
        return this.applicationConfig.getOptionAsVersion(GcRestApiConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {
        this.setOption(GcRestApiConfigOption.BUILD_VERSION.getKey(), (Object)buildVersion);
    }

    public String getBuildDate() {
        return this.applicationConfig.getOption(GcRestApiConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {
        this.setOption(GcRestApiConfigOption.BUILD_DATE.getKey(), (Object)buildDate);
    }

    public String getBuildNumber() {
        return this.applicationConfig.getOption(GcRestApiConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {
        this.setOption(GcRestApiConfigOption.BUILD_NUMBER.getKey(), (Object)buildNumber);
    }

    public boolean isDevMode() {
        return this.applicationConfig.getOptionAsBoolean(GcRestApiConfigOption.DEV_MODE.getKey());
    }

    public void setDevMode(boolean devMode) {
        this.setOption(GcRestApiConfigOption.DEV_MODE.getKey(), (Object)devMode);
    }

    public String getClassifier() {
        return this.applicationConfig.getOption(GcRestApiConfigOption.CLASSIFIER.getKey());
    }

    public void setClassifier(String classifier) {
        this.setOption(GcRestApiConfigOption.CLASSIFIER.getKey(), (Object)classifier);
    }

    public File getBaseDirectory() {
        return this.applicationConfig.getOptionAsFile(GcRestApiConfigOption.BASE_DIRECTORY.getKey());
    }

    public void setBaseDirectory(File baseDirectory) {
        this.setOption(GcRestApiConfigOption.BASE_DIRECTORY.getKey(), (Object)baseDirectory);
    }

    public File getTemporaryDirectory() {
        return this.applicationConfig.getOptionAsFile(GcRestApiConfigOption.TEMPORARY_DIRECTORY.getKey());
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        this.setOption(GcRestApiConfigOption.TEMPORARY_DIRECTORY.getKey(), (Object)temporaryDirectory);
    }

    public File getLog4jConfigurationFile() {
        return this.applicationConfig.getOptionAsFile(GcRestApiConfigOption.LOG4J_CONFIGURATION_FILE.getKey());
    }

    public void setLog4jConfigurationFile(File log4jConfigurationFile) {
        this.setOption(GcRestApiConfigOption.LOG4J_CONFIGURATION_FILE.getKey(), (Object)log4jConfigurationFile);
    }

    public int getSessionExpirationDelay() {
        return this.applicationConfig.getOptionAsInt(GcRestApiConfigOption.SESSION_EXPIRATION_DELAY.getKey());
    }

    public void setSessionExpirationDelay(int sessionExpirationDelay) {
        this.setOption(GcRestApiConfigOption.SESSION_EXPIRATION_DELAY.getKey(), (Object)sessionExpirationDelay);
    }

    public int getHttpTimeout() {
        return this.applicationConfig.getOptionAsInt(GcRestApiConfigOption.HTTP_TIMEOUT.getKey());
    }

    public void setHttpTimeout(int httpTimeout) {
        this.setOption(GcRestApiConfigOption.HTTP_TIMEOUT.getKey(), (Object)httpTimeout);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", this.get().getConfigFileName()));
        for (GcRestApiConfigOption option : this.orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), this.get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcRestApiConfigOption> orderedByKey() {
        List<GcRestApiConfigOption> values = Arrays.asList(GcRestApiConfigOption.values());
        Collections.sort(values, new /* Unavailable Anonymous Inner Class!! */);
        return Collections.unmodifiableList(values);
    }
}

