package io.ultreia.gc.rest.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Generated;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.version.Version;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Tue Jun 27 20:05:05 UTC 2017")
public abstract class GeneratedGcRestApiConfig implements Supplier<ApplicationConfig> {

    private ApplicationConfig applicationConfig;

    protected GeneratedGcRestApiConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedGcRestApiConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions(GcRestApiConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getConfigFile() {
        return applicationConfig.getOption(GcRestApiConfigOption.CONFIG_FILE.getKey());
    }

    public void setConfigFile(String configFile) {    setOption(GcRestApiConfigOption.CONFIG_FILE.getKey(), configFile);
    }

    public Version getBuildVersion() {
        return applicationConfig.getOptionAsVersion(GcRestApiConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {    setOption(GcRestApiConfigOption.BUILD_VERSION.getKey(), buildVersion);
    }

    public String getBuildDate() {
        return applicationConfig.getOption(GcRestApiConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {    setOption(GcRestApiConfigOption.BUILD_DATE.getKey(), buildDate);
    }

    public String getBuildNumber() {
        return applicationConfig.getOption(GcRestApiConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {    setOption(GcRestApiConfigOption.BUILD_NUMBER.getKey(), buildNumber);
    }

    public boolean isDevMode() {
        return applicationConfig.getOptionAsBoolean(GcRestApiConfigOption.DEV_MODE.getKey());
    }

    public void setDevMode(boolean devMode) {    setOption(GcRestApiConfigOption.DEV_MODE.getKey(), devMode);
    }

    public String getClassifier() {
        return applicationConfig.getOption(GcRestApiConfigOption.CLASSIFIER.getKey());
    }

    public void setClassifier(String classifier) {    setOption(GcRestApiConfigOption.CLASSIFIER.getKey(), classifier);
    }

    public File getBaseDirectory() {
        return applicationConfig.getOptionAsFile(GcRestApiConfigOption.BASE_DIRECTORY.getKey());
    }

    public void setBaseDirectory(File baseDirectory) {    setOption(GcRestApiConfigOption.BASE_DIRECTORY.getKey(), baseDirectory);
    }

    public File getTemporaryDirectory() {
        return applicationConfig.getOptionAsFile(GcRestApiConfigOption.TEMPORARY_DIRECTORY.getKey());
    }

    public void setTemporaryDirectory(File temporaryDirectory) {    setOption(GcRestApiConfigOption.TEMPORARY_DIRECTORY.getKey(), temporaryDirectory);
    }

    public File getLog4jConfigurationFile() {
        return applicationConfig.getOptionAsFile(GcRestApiConfigOption.LOG4J_CONFIGURATION_FILE.getKey());
    }

    public void setLog4jConfigurationFile(File log4jConfigurationFile) {    setOption(GcRestApiConfigOption.LOG4J_CONFIGURATION_FILE.getKey(), log4jConfigurationFile);
    }

    public int getSessionExpirationDelay() {
        return applicationConfig.getOptionAsInt(GcRestApiConfigOption.SESSION_EXPIRATION_DELAY.getKey());
    }

    public void setSessionExpirationDelay(int sessionExpirationDelay) {    setOption(GcRestApiConfigOption.SESSION_EXPIRATION_DELAY.getKey(), sessionExpirationDelay);
    }

    public int getHttpTimeout() {
        return applicationConfig.getOptionAsInt(GcRestApiConfigOption.HTTP_TIMEOUT.getKey());
    }

    public void setHttpTimeout(int httpTimeout) {    setOption(GcRestApiConfigOption.HTTP_TIMEOUT.getKey(), httpTimeout);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", get().getConfigFileName()));
        for (GcRestApiConfigOption option : orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcRestApiConfigOption> orderedByKey() {
        List<GcRestApiConfigOption> values = Arrays.asList(GcRestApiConfigOption.values());
        Collections.sort(values, new Comparator<GcRestApiConfigOption>() {
            @Override
            public int compare(GcRestApiConfigOption o1, GcRestApiConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }

} //GeneratedGcRestApiConfig
