/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api.internal;

import com.google.common.base.Strings;
import io.ultreia.gc.rest.api.GcRestApiApplicationContext;
import io.ultreia.gc.rest.api.GcRestApiRequestContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.debux.webmotion.server.WebMotionFilter;
import org.debux.webmotion.server.call.HttpContext;

public class GcRestMotionFilter
extends WebMotionFilter {
    private static final String REQUEST_AUTHENTICATION_TOKEN = "Authorization";

    public void inject(HttpContext context) {
        GcRestApiApplicationContext applicationContext = GcRestApiApplicationContext.getApplicationContext((HttpContext)context);
        HttpServletRequest request = context.getRequest();
        String authenticationToken = this.getRequestHeaderOrParameterValueOrNull(request, REQUEST_AUTHENTICATION_TOKEN);
        authenticationToken = Strings.isNullOrEmpty((String)authenticationToken) ? null : authenticationToken.replaceAll("\"", "");
        GcRestApiRequestContext requestContext = new GcRestApiRequestContext(applicationContext, authenticationToken);
        GcRestApiRequestContext.setRequestContext((HttpContext)context, (GcRestApiRequestContext)requestContext);
        this.doProcess();
    }

    private String getRequestHeaderOrParameterValueOrNull(HttpServletRequest request, String parameterName) {
        String result = request.getHeader(parameterName);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.getRequestParameterValueOrNull(request, parameterName);
        }
        return result;
    }

    private String getRequestParameterValueOrNull(HttpServletRequest request, String parameterName) {
        String parameterValue = request.getParameter(parameterName);
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            parameterValue = null;
        }
        return parameterValue;
    }
}

