/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import io.ultreia.gc.db.ApplicationConfig2;
import io.ultreia.gc.rest.api.GcRestApiConfigInitException;
import io.ultreia.gc.rest.api.GcRestApiConfigOption;
import io.ultreia.gc.rest.api.GeneratedGcRestApiConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ApplicationConfigScope;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.topia.persistence.TopiaException;

/*
 * Exception performing whole class analysis ignored.
 */
public class GcRestApiConfig
extends GeneratedGcRestApiConfig {
    private static Log log = LogFactory.getLog(GcRestApiConfig.class);

    GcRestApiConfig(String classifier, String ... args) {
        log.info((Object)String.format("Create rest api config (%s), args: %s", classifier, Arrays.toString(args)));
        this.get().setDefaultOption(GcRestApiConfigOption.CLASSIFIER.getKey(), classifier);
        ApplicationConfig2 defaultConf = new ApplicationConfig2(ApplicationConfigInit.forScopes((ApplicationConfigScope[])new ApplicationConfigScope[]{ApplicationConfigScope.CLASS_PATH, ApplicationConfigScope.DEFAULTS, ApplicationConfigScope.OPTIONS}).setConfigFileName("gc-rest-api.conf"));
        try {
            defaultConf.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new TopiaException((Throwable)e);
        }
        Properties properties = defaultConf.getProperties(ApplicationConfigScope.CLASS_PATH);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.get().setDefaultOption("" + entry.getKey(), "" + entry.getValue());
        }
        log.info((Object)String.format("Use %s configuration file", this.getConfigFile()));
        this.get().setConfigFileName(this.getConfigFile());
        this.init(args);
        log.info((Object)String.format("rest api config is initialized:\n%s", this.getConfigurationDescription()));
    }

    private void init(String ... args) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Init rest api config %s", Arrays.asList(args)));
        }
        try {
            this.get().parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new GcRestApiConfigInitException("could not parse configuration", (Throwable)e);
        }
        File baseDirectory = this.getBaseDirectory();
        if (this.isDevMode() && !baseDirectory.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Using a dev mode configuration.");
            }
            try {
                Path tmpdir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                if (!Files.exists(tmpdir, new LinkOption[0])) {
                    Files.createDirectories(tmpdir, new FileAttribute[0]);
                }
                baseDirectory = Files.createTempDirectory("gc-rest-api", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new GcRestApiConfigInitException("could not create temporary basedir", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Dev mode detected, use temporary basedir: " + baseDirectory));
            }
            this.setBaseDirectory(baseDirectory);
        }
        try {
            Files.createDirectories(baseDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GcRestApiConfigInitException("Impossible de cr\u00e9er le r\u00e9pertoire principal de l'application (" + baseDirectory + ")", (Throwable)e);
        }
        File temporaryDirectory = this.getTemporaryDirectory();
        try {
            Files.createDirectories(temporaryDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GcRestApiConfigInitException("Impossible de cr\u00e9er le r\u00e9pertoire temporaire de l'application (" + temporaryDirectory + ")", (Throwable)e);
        }
        File log4jConfigurationFile = this.getLog4jConfigurationFile();
        if (!log4jConfigurationFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Generate default log4jConfigurationFile");
            }
            try {
                CharSource charSource = Resources.asCharSource((URL)this.getClass().getResource("/gc-rest-api-log4j.conf"), (Charset)Charsets.UTF_8);
                Files.write(log4jConfigurationFile.toPath(), (Iterable<? extends CharSequence>)charSource.readLines(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new GcRestApiConfigInitException("Impossible de cr\u00e9er un fichier de log4j", (Throwable)e);
            }
        }
        this.initLog();
    }

    private void initLog() {
        Properties finalLogConfigurationProperties;
        File logFile = this.getLog4jConfigurationFile();
        if (!logFile.exists()) {
            throw new GcRestApiConfigInitException("Le fichier de configuration des logs (" + logFile + ") n'existe pas");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Chargement du fichier de log : " + logFile));
        }
        try (BufferedReader inputStream = Files.newBufferedReader(logFile.toPath(), Charsets.UTF_8);){
            Properties logConfigurationProperties = new Properties();
            logConfigurationProperties.load(inputStream);
            finalLogConfigurationProperties = GcRestApiConfig.loadProperties((Properties)logConfigurationProperties, (ApplicationConfig)this.get());
        }
        catch (Exception e) {
            throw new GcRestApiConfigInitException("Impossible de charger le fichier de configuration des logs", (Throwable)e);
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)finalLogConfigurationProperties);
        log = LogFactory.getLog(GcRestApiConfig.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Configuration des logs charg\u00e9e depuis le fichier " + logFile));
        }
    }

    public static Properties loadProperties(Properties sourceProperties, ApplicationConfig config) {
        Properties targetProperties = new Properties();
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String newValue = config.replaceRecursiveOptions(value);
            targetProperties.setProperty(key, newValue);
        }
        return targetProperties;
    }
}

