/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api.internal.injector;

import com.google.gson.Gson;
import io.ultreia.gc.model.GcDto;
import java.lang.reflect.Type;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;

public class GcDtoInjector
extends AbstractConverter
implements ExecutorParametersInjectorHandler.Injector {
    private static final Log log = LogFactory.getLog(GcDtoInjector.class);
    private final Gson gson;

    public GcDtoInjector(Gson gson) {
        this.gson = gson;
    }

    public Object getValue(Mapping mapping, Call call, String name, Class<?> type, Type generic) {
        GcDto observeDto = null;
        if (GcDto.class.isAssignableFrom(type)) {
            Call.ParameterTree parameterTree = (Call.ParameterTree)call.getParameterTree().getObject().get(name);
            String gsonContent = ((String[])parameterTree.getValue())[0];
            observeDto = (GcDto)this.gson.fromJson(gsonContent, generic);
            log.debug((Object)("Inject observeDto: " + observeDto));
        }
        return observeDto;
    }

    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (!GcDto.class.isAssignableFrom(type)) {
            throw this.conversionException(type, value);
        }
        String gsonContent = value.toString();
        Object observeDto = this.gson.fromJson(gsonContent, type);
        log.debug((Object)("convert observeDto: " + observeDto));
        return (T)observeDto;
    }

    protected Class<?> getDefaultType() {
        return GcDto.class;
    }
}

