/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api.internal;

import com.google.gson.Gson;
import io.ultreia.gc.rest.api.GcRestApiApplicationContext;
import io.ultreia.gc.rest.api.GcRestApiApplicationContextInitException;
import io.ultreia.gc.rest.api.internal.injector.GcDtoInjector;
import io.ultreia.gc.rest.api.internal.injector.GcRestClassInjector;
import io.ultreia.gc.rest.api.internal.injector.ImmutableSetInjector;
import java.io.Closeable;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.WebMotionServerListener;
import org.debux.webmotion.server.call.ServerContext;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;

public class GcRestApplicationListener
implements WebMotionServerListener {
    private static final Log log = LogFactory.getLog(GcRestApplicationListener.class);
    private GcRestApiApplicationContext applicationContext;

    public void onStart(Mapping mapping, ServerContext context) {
        log.info((Object)("Initializing " + GcRestApplicationListener.class.getName()));
        String contextPath = StringUtils.removeStart((String)context.getServletContext().getContextPath(), (String)"/");
        if (contextPath.isEmpty()) {
            contextPath = "ROOT";
        }
        log.info((Object)String.format("Application starting on [%s] at %s...", contextPath, new Date()));
        this.applicationContext = new GcRestApiApplicationContext();
        try {
            this.applicationContext.init(context.getServletContext().getContextPath());
        }
        catch (Exception e) {
            throw new GcRestApiApplicationContextInitException("Impossible d'initialiser le context applicatif", (Throwable)e);
        }
        Gson gson = this.applicationContext.getGsonSupplier().get();
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new GcRestClassInjector());
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new GcDtoInjector(gson));
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new ImmutableSetInjector());
        context.getServletContext().setAttribute(GcRestApiApplicationContext.APPLICATION_CONTEXT_PARAMETER, (Object)this.applicationContext);
        if (log.isInfoEnabled()) {
            log.info((Object)("Initializing " + GcRestApplicationListener.class.getName() + " done."));
        }
    }

    public void onStop(ServerContext context) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroying " + GcRestApplicationListener.class.getName()));
        }
        IOUtils.closeQuietly((Closeable)this.applicationContext);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroying " + GcRestApplicationListener.class.getName() + " done."));
        }
    }
}

