/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.api;

import com.google.common.base.Preconditions;
import io.ultreia.gc.rest.api.GcRestApiApplicationContext;
import io.ultreia.gc.rest.api.GcRestApiConfig;
import io.ultreia.gc.rest.api.internal.GcDtoGsonSupplier;
import io.ultreia.gc.rest.api.internal.GcRestApplicationListener;
import java.io.Closeable;
import javax.servlet.ServletContext;
import org.debux.webmotion.server.call.HttpContext;

public class GcRestApiApplicationContext
implements Closeable {
    public static final String APPLICATION_CONTEXT_PARAMETER = GcRestApiApplicationContext.class.getName();
    private static final String MISSING_APPLICATION_CONTEXT = GcRestApiApplicationContext.class.getSimpleName() + " not found. You probably forgot to register " + GcRestApplicationListener.class.getName() + " in your web.xml";
    private GcDtoGsonSupplier gsonSupplier;
    private GcRestApiConfig config;
    private final GcRestApiSessions sessions = new GcRestApiSessions();

    public static GcRestApiApplicationContext getApplicationContext(HttpContext context) {
        ServletContext servletContext = context.getServletContext();
        GcRestApiApplicationContext result = (GcRestApiApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)MISSING_APPLICATION_CONTEXT);
        return result;
    }

    public void init(String contextPath) {
        this.config = GcRestApiConfig.fromContextPath((String)contextPath);
        boolean devMode = this.config.isDevMode();
        this.gsonSupplier = new GcDtoGsonSupplier(devMode);
    }

    @Override
    public void close() {
        this.sessions.close();
    }

    public GcDtoGsonSupplier getGsonSupplier() {
        return this.gsonSupplier;
    }

    public GcRestApiConfig getConfig() {
        return this.config;
    }

    public GcRestApiSessions getSessions() {
        return this.sessions;
    }
}

