package io.ultreia.gc.rest.api.v1;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import io.ultreia.gc.model.GcArcheoLog;
import io.ultreia.gc.model.GcLog;
import io.ultreia.gc.rest.api.GcRestApiServiceSupport;
import io.ultreia.gc.service.api.GcLogService;
import java.util.List;
import java.util.Optional;

/**
 * Created by tchemit on 26/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcLogServiceRestApi extends GcRestApiServiceSupport<GcLogService> implements GcLogService {

    public GcLogServiceRestApi() {
        super(GcLogService.class);
    }

    @Override
    public void loadLogs() {
        getService().loadLogs();
    }

    @Override
    public List<GcLog> getLogsFromGcName(String gcName) {
        return getService().getLogsFromGcName(gcName);
    }

    @Override
    public void deleteLogsForGcName(String gcName) {
        getService().deleteLogsForGcName(gcName);
    }

    @Override
    public Optional<GcArcheoLog> getMyArcheoLogFromGcName(String gcName, String username) {
        return getService().getMyArcheoLogFromGcName(gcName, username);
    }
}
