package io.ultreia.gc.rest.api.v1;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.rest.api.GcRestApiServiceSupport;
import io.ultreia.gc.service.api.GcCacheService;
import java.util.List;

/**
 * Created by tchemit on 26/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcCacheServiceRestApi extends GcRestApiServiceSupport<GcCacheService> implements GcCacheService {

    public GcCacheServiceRestApi() {
        super(GcCacheService.class);
    }

    @Override
    public GcCache getCacheFromGcName(String gcName) {
        return getService().getCacheFromGcName(gcName);
    }

    @Override
    public void storeCache(GcCache cache) {
        getService().storeCache(cache);
    }

    @Override
    public List<String> getGcNames() {
        return getService().getGcNames();
    }

    @Override
    public List<String> getGcNamesWithoutLogs() {
        return getService().getGcNamesWithoutLogs();
    }

    @Override
    public List<GcCache> searchCaches(GcSearchFilter filter) {
        return getService().searchCaches(filter);
    }

    @Override
    public void getCacheFromGuid(String guid) {
        getService().getCacheFromGuid(guid);
    }

    @Override
    public GcCache getCacheRefFromGcName(String gcName) {
        return getService().getCacheFromGcName(gcName);
    }
}
