package io.ultreia.gc.rest.api.v1;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import io.ultreia.gc.model.GcFieldNote;
import io.ultreia.gc.model.GcLogDraft;
import io.ultreia.gc.rest.api.GcRestApiServiceSupport;
import io.ultreia.gc.service.api.FieldNotesService;
import java.util.List;

/**
 * Created by tchemit on 05/05/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class FieldNotesServiceRestApi extends GcRestApiServiceSupport<FieldNotesService> implements FieldNotesService {

    public FieldNotesServiceRestApi() {
        super(FieldNotesService.class);
    }

    @Override
    public List<GcFieldNote> loadFieldNotes() {
        return getService().loadFieldNotes();
    }

    @Override
    public void logFieldNote(GcFieldNote fieldNote, String logText, boolean autoVisitTrackables) {
        getService().logFieldNote(fieldNote, logText, autoVisitTrackables);
    }

    @Override
    public GcLogDraft getLogDraft(String referenceCode) {
        return getService().getLogDraft(referenceCode);
    }
}
