package io.ultreia.gc.rest.api.internal.injector;

/*-
 * #%L
 * GC toolkit :: REST API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;

/**
 * @author Sylvain Bavencoff - bavencoff@codelutin.com
 */
public class GcRestClassInjector implements ExecutorParametersInjectorHandler.Injector {

    /** Logger. */
    private static final Log log = LogFactory.getLog(GcRestClassInjector.class);

    @Override
    public Object getValue(Mapping mapping, Call call, String name, Class<?> type, Type generic) {

        Class<?> result = null;

        if (type.equals(Class.class)) {

            Call.ParameterTree parameterTree = call.getParameterTree().getObject().get(name);
            Objects.requireNonNull(parameterTree, "Le paramètre " + name + " n'as pas été trouvé, recompiler (parameter)!");

            String className = ((String[]) parameterTree.getValue())[0];
            className = className.replace("\"", "");
            try {
                result = Class.forName(className);
            } catch (ClassNotFoundException cnfe) {
                if (log.isErrorEnabled()) {
                    log.error("An exception occurred", cnfe);
                }
                throw new JsonParseException("Class not found: " + className, cnfe);
            }

        }

        return result;
    }
}
