/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import io.ultreia.gc.db.entity.AbstractGcUserTopiaDao;
import io.ultreia.gc.db.entity.GcUser;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GcUserTopiaDao
extends AbstractGcUserTopiaDao<GcUser> {
    private static final Log log = LogFactory.getLog(GcUserTopiaDao.class);

    public void consolidate(GcUser gcUser) {
        List gcUsers = this.forNameEquals(gcUser.getName()).findAll();
        gcUsers.addAll(this.forUserGuidEquals(gcUser.getUserGuid()).findAll());
        gcUsers.addAll(this.forUserGuidEquals(gcUser.getUserId() + "").findAll());
        gcUsers.addAll(this.forUserIdEquals(gcUser.getUserId()).findAll());
        String gcUserTopiaId = gcUser.getTopiaId();
        gcUsers.removeIf(u -> u.getTopiaId().equals(gcUserTopiaId));
        gcUsers.removeIf(u -> u.getUserGuid() != null && u.getUserId() > 0);
        log.info((Object)String.format("Found %d user(s) to remove (user: %s - %s - %s)", gcUsers.size(), gcUser.getName(), gcUser.getUserId(), gcUser.getUserGuid()));
        for (GcUser user : gcUsers) {
            log.info((Object)String.format("Replace obsolete user: %s - %d - %s", user.getName(), user.getUserId(), user.getUserGuid()));
            this.topiaSqlSupport.executeSql(String.format("update gcCache set owner = '%s' where owner='%s'", gcUserTopiaId, user.getTopiaId()));
            log.info((Object)String.format("Delete obsolete user: %s - %d - %s", user.getName(), user.getUserId(), user.getUserGuid()));
            this.delete(user);
        }
    }
}

