/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum GcTerrain {
    T1(1.0f),
    T1_5(1.5f),
    T2(2.0f),
    T2_5(2.5f),
    T3(3.0f),
    T3_5(3.5f),
    T4(4.0f),
    T4_5(4.5f),
    T5(5.0f);

    private final float code;

    private GcTerrain(float code) {
        this.code = code;
    }

    public float getCode() {
        return this.code;
    }

    public String toString() {
        return this.name().substring(1).replace("_", ".");
    }

    public static GcTerrain valueOf(float code) {
        for (GcTerrain gcTerrain : GcTerrain.values()) {
            if (code != gcTerrain.code) continue;
            return gcTerrain;
        }
        throw new IllegalStateException("Can't find terrain with code: " + code);
    }

    public static List<GcTerrain> reverseValues() {
        List<GcTerrain> result = Arrays.asList(GcTerrain.values());
        Collections.reverse(result);
        return result;
    }
}

