/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import io.ultreia.gc.db.entity.GcCountry;
import io.ultreia.gc.db.entity.GcReferential;

public enum GcState implements GcReferential
{
    United_States__Wyoming(2, 51),
    United_States__Wisconsin(2, 50),
    United_States__West_Virginia(2, 49),
    United_States__Washington(2, 48),
    United_States__Virginia(2, 47),
    United_States__Vermont(2, 46),
    United_States__Utah(2, 45),
    United_States__Texas(2, 44),
    United_States__Tennessee(2, 43),
    United_States__South_Dakota(2, 42),
    United_States__South_Carolina(2, 41),
    United_States__Rhode_Island(2, 40),
    United_States__Pennsylvania(2, 39),
    United_States__Oregon(2, 38),
    United_States__Oklahoma(2, 37),
    United_States__Ohio(2, 36),
    United_States__North_Dakota(2, 35),
    United_States__North_Carolina(2, 34),
    United_States__New_York(2, 33),
    United_States__New_Mexico(2, 32),
    United_States__New_Jersey(2, 31),
    United_States__New_Hampshire(2, 30),
    United_States__Nevada(2, 29),
    United_States__Nebraska(2, 28),
    United_States__Montana(2, 27),
    United_States__Missouri(2, 26),
    United_States__Mississippi(2, 25),
    United_States__Minnesota(2, 24),
    United_States__Michigan(2, 23),
    United_States__Massachusetts(2, 22),
    United_States__Maryland(2, 21),
    United_States__Maine(2, 20),
    United_States__Louisiana(2, 19),
    United_States__Kentucky(2, 18),
    United_States__Kansas(2, 17),
    United_States__Iowa(2, 16),
    United_States__Indiana(2, 15),
    United_States__Illinois(2, 14),
    United_States__Idaho(2, 13),
    United_States__Hawaii(2, 12),
    United_States__Georgia(2, 11),
    United_States__Florida(2, 10),
    United_States__District_of_Columbia(2, 8),
    United_States__Delaware(2, 9),
    United_States__Connecticut(2, 7),
    United_States__Colorado(2, 6),
    United_States__California(2, 5),
    United_States__Arkansas(2, 4),
    United_States__Arizona(2, 3),
    United_States__Alaska(2, 2),
    United_States__Alabama(2, 60),
    United_Kingdom__Yorkshire(11, 214),
    United_Kingdom__West_Midlands(11, 216),
    United_Kingdom__Southern_Scotland(11, 211),
    United_Kingdom__Southern_England(11, 221),
    United_Kingdom__South_West_England(11, 222),
    United_Kingdom__South_Wales(11, 218),
    United_Kingdom__South_East_England(11, 223),
    United_Kingdom__Northwest_England(11, 213),
    United_Kingdom__Northern_Scotland(11, 210),
    United_Kingdom__Northeast_England(11, 212),
    United_Kingdom__North_Wales(11, 217),
    United_Kingdom__London(11, 220),
    United_Kingdom__Eastern_England(11, 219),
    United_Kingdom__East_Midlands(11, 215),
    Switzerland__Zentralschweiz__ZG_SZ_LU_UR_OW_NW_(192, 233),
    Switzerland__Wallis__VS_(192, 237),
    Switzerland__Tessin__TI_(192, 238),
    Switzerland__Suisse_romande__GE_VD_FR_(192, 235),
    Switzerland__Region_Zuerich__ZH_(192, 231),
    Switzerland__Ostschweiz__SG_SH_TG_AI_AR_GL_(192, 230),
    Switzerland__Nordwestschweiz__AG_BL_BS_(192, 232),
    Switzerland__Jura__JU_NE_(192, 236),
    Switzerland__Graubuenden__GR_(192, 229),
    Switzerland__Espace_Mittelland__BE_SO_(192, 234),
    Sweden__V\u00e4stra_G\u00f6taland(10, 377),
    Sweden__V\u00e4stmanland(10, 376),
    Sweden__V\u00e4sternorrland(10, 375),
    Sweden__V\u00e4sterbotten(10, 374),
    Sweden__V\u00e4rmland(10, 373),
    Sweden__Uppsala(10, 372),
    Sweden__Stockholm(10, 370),
    Sweden__S\u00f6dermanland(10, 371),
    Sweden__Sk\u00e5ne(10, 369),
    Sweden__\u00d6sterg\u00f6tland(10, 379),
    Sweden__\u00d6rebro(10, 378),
    Sweden__Norrbotten(10, 368),
    Sweden__Kronoberg(10, 367),
    Sweden__Kalmar(10, 366),
    Sweden__J\u00f6nk\u00f6ping(10, 365),
    Sweden__J\u00e4mtland(10, 364),
    Sweden__Halland(10, 363),
    Sweden__Gotland(10, 361),
    Sweden__G\u00e4vleborg(10, 362),
    Sweden__Dalarna(10, 360),
    Sweden__Blekinge(10, 359),
    Spain__Regi\u00f3n_de_Murcia(186, 124),
    Spain__Principado_de_Asturias(186, 125),
    Spain__Pa\u00eds_Vasco(186, 129),
    Spain__Melilla(186, 134),
    Spain__La_Rioja(186, 131),
    Spain__Islas_Canarias(186, 128),
    Spain__Islas_Baleares(186, 132),
    Spain__Galicia(186, 122),
    Spain__Extremadura(186, 120),
    Spain__Comunidad_Valenciana(186, 123),
    Spain__Comunidad_Foral_de_Navarra(186, 126),
    Spain__Comunidad_de_Madrid(186, 127),
    Spain__Ceuta(186, 133),
    Spain__Catalu\u00f1a(186, 121),
    Spain__Castilla_La_Mancha(186, 117),
    Spain__Castilla_y_Le\u00f3n(186, 115),
    Spain__Cantabria(186, 130),
    Spain__Arag\u00f3n(186, 119),
    Spain__Andaluc\u00eda(186, 116),
    South_Korea__Ulsan(180, 302),
    South_Korea__Seoul(180, 296),
    South_Korea__Jeolla_nam_do(180, 308),
    South_Korea__Jeolla_buk_do(180, 307),
    South_Korea__Jejudo(180, 311),
    South_Korea__Incheon(180, 299),
    South_Korea__Gyeongsang_nam_do(180, 310),
    South_Korea__Gyeongsang_buk_do(180, 309),
    South_Korea__Gyeonggido(180, 303),
    South_Korea__Gwangju(180, 300),
    South_Korea__Gangwondo(180, 304),
    South_Korea__Daejeon(180, 301),
    South_Korea__Daegu(180, 298),
    South_Korea__Chungcheong_nam_do(180, 306),
    South_Korea__Chungcheong_buk_do(180, 305),
    South_Korea__Busan(180, 297),
    South_Africa__Western_Cape(165, 152),
    South_Africa__Northern_Cape(165, 154),
    South_Africa__North_West(165, 156),
    South_Africa__Mpumalanga(165, 155),
    South_Africa__Limpopo(165, 158),
    South_Africa__Kwazulu_Natal(165, 157),
    South_Africa__Gauteng(165, 159),
    South_Africa__Free_State(165, 160),
    South_Africa__Eastern_Cape(165, 153),
    Slovakia__\u017dilinsk\u00fd_kraj(181, 294),
    Slovakia__Trnavsk\u00fd_kraj(181, 293),
    Slovakia__Tren\u010diansky_kraj(181, 292),
    Slovakia__Pre\u0161ovsk\u00fd_kraj(181, 291),
    Slovakia__Nitriansky_kraj(181, 290),
    Slovakia__Ko\u0161ick\u00fd_kraj(181, 289),
    Slovakia__Bratislavsk\u00fd_kraj(181, 288),
    Slovakia__Banskobystrick\u00fd_kraj(181, 287),
    Portugal__Viseu(159, 111),
    Portugal__Vila_Real(159, 112),
    Portugal__Viana_do_Castelo(159, 110),
    Portugal__Set\u00fabal(159, 109),
    Portugal__Santar\u00e9m(159, 108),
    Portugal__Porto(159, 107),
    Portugal__Portalegre(159, 106),
    Portugal__Lisboa(159, 105),
    Portugal__Leiria(159, 104),
    Portugal__Guarda(159, 103),
    Portugal__Faro(159, 102),
    Portugal__\u00c9vora(159, 101),
    Portugal__Coimbra(159, 100),
    Portugal__Castelo_Branco(159, 99),
    Portugal__Bragan\u00e7a(159, 98),
    Portugal__Braga(159, 97),
    Portugal__Beja(159, 96),
    Portugal__Aveiro(159, 95),
    Portugal__Arquip\u00e9lago_dos_A\u00e7ores(159, 114),
    Portugal__Arquip\u00e9lago_da_Madeira(159, 113),
    Poland__Zachodniopomorskie(158, 411),
    Poland__Wielkopolskie(158, 410),
    Poland__Warmi\u0144sko_Mazurskie(158, 409),
    Poland__\u015awi\u0119tokrzyskie(158, 408),
    Poland__\u015al\u0105skie(158, 407),
    Poland__Pomorskie(158, 406),
    Poland__Podlaskie(158, 405),
    Poland__Podkarpackie(158, 404),
    Poland__Opolskie(158, 403),
    Poland__Mazowieckie(158, 402),
    Poland__Ma\u0142opolskie(158, 401),
    Poland__Lubuskie(158, 399),
    Poland__Lubelskie(158, 398),
    Poland__\u0141\u00f3dzkie(158, 400),
    Poland__Kujawsko_Pomorskie(158, 397),
    Poland__Dolno\u015bl\u0105skie(158, 396),
    Norway__Vestfold(147, 246),
    Norway__Vest_Agder(147, 248),
    Norway__Troms(147, 256),
    Norway__Telemark(147, 245),
    Norway__S\u00f8r_Tr\u00f8ndelag(147, 253),
    Norway__Sogn_og_Fjordane(147, 251),
    Norway__Rogaland(147, 249),
    Norway__\u00d8stfold(147, 239),
    Norway__Oslo(147, 241),
    Norway__Oppland(147, 243),
    Norway__Nord_Tr\u00f8ndelag(147, 254),
    Norway__Nordland(147, 255),
    Norway__M\u00f8re_og_Romsdal(147, 252),
    Norway__Hordaland(147, 250),
    Norway__Hedmark(147, 242),
    Norway__Finnmark(147, 257),
    Norway__Buskerud(147, 244),
    Norway__Aust_Agder(147, 247),
    Norway__Akershus(147, 240),
    New_Zealand_South_Island(9, 86),
    New_Zealand_North_Island(9, 82),
    New_Zealand_Chatham_Islands(9, 486),
    Netherlands__Zuid_Holland(141, 390),
    Netherlands__Zeeland(141, 391),
    Netherlands__Utrecht(141, 388),
    Netherlands__Overijssel(141, 386),
    Netherlands__Noord_Holland(141, 389),
    Netherlands__Noord_Brabant(141, 392),
    Netherlands__Limburg(141, 393),
    Netherlands__Groningen(141, 384),
    Netherlands__Gelderland(141, 387),
    Netherlands__Friesland(141, 394),
    Netherlands__Flevoland(141, 395),
    Netherlands__Drenthe(141, 385),
    Mexico__Zacatecas(228, 485),
    Mexico__Yucat\u00e1n(228, 484),
    Mexico__Veracruz(228, 483),
    Mexico__Tlaxcala(228, 482),
    Mexico__Tamaulipas(228, 481),
    Mexico__Tabasco(228, 480),
    Mexico__Sonora(228, 479),
    Mexico__Sinaloa(228, 478),
    Mexico__San_Luis_Potos\u00ed(228, 477),
    Mexico__Quintana_Roo(228, 476),
    Mexico__Quer\u00e9taro(228, 475),
    Mexico__Puebla(228, 474),
    Mexico__Oaxaca(228, 473),
    Mexico__Nuevo_Le\u00f3n(228, 472),
    Mexico__Nayarit(228, 471),
    Mexico__Morelos(228, 470),
    Mexico__Michoac\u00e1n(228, 469),
    Mexico__M\u00e9xico(228, 468),
    Mexico__Jalisco(228, 467),
    Mexico__Hidalgo(228, 466),
    Mexico__Guerrero(228, 465),
    Mexico__Guanajuato(228, 464),
    Mexico__Durango(228, 463),
    Mexico__Distrito_Federal(228, 462),
    Mexico__Colima(228, 461),
    Mexico__Coahuila(228, 460),
    Mexico__Chihuahua(228, 459),
    Mexico__Chiapas(228, 458),
    Mexico__Campeche(228, 457),
    Mexico__Baja_California_Sur(228, 456),
    Mexico__Baja_California(228, 455),
    Mexico__Aguascalientes(228, 454),
    Japan__Yamanashi(104, 357),
    Japan__Yamaguchi(104, 356),
    Japan__Yamagata(104, 355),
    Japan__Wakayama(104, 354),
    Japan__Toyama(104, 353),
    Japan__Tottori(104, 352),
    Japan__Tokyo(104, 351),
    Japan__Tokushima(104, 350),
    Japan__Tochigi(104, 349),
    Japan__Shizuoka(104, 348),
    Japan__Shimane(104, 347),
    Japan__Shiga(104, 346),
    Japan__Saitama(104, 345),
    Japan__Saga(104, 344),
    Japan__Osaka(104, 343),
    Japan__Okinawa(104, 342),
    Japan__Okayama(104, 341),
    Japan__Oita(104, 340),
    Japan__Niigata(104, 339),
    Japan__Nara(104, 338),
    Japan__Nagasaki(104, 337),
    Japan__Nagano(104, 336),
    Japan__Miyazaki(104, 335),
    Japan__Miyagi(104, 334),
    Japan__Mie(104, 333),
    Japan__Kyoto(104, 332),
    Japan__Kumamoto(104, 331),
    Japan__Kochi(104, 330),
    Japan__Kanagawa(104, 329),
    Japan__Kagoshima(104, 328),
    Japan__Kagawa(104, 327),
    Japan__Iwate(104, 326),
    Japan__Ishikawa(104, 325),
    Japan__Ibaraki(104, 324),
    Japan__Hyogo(104, 323),
    Japan__Hokkaido(104, 322),
    Japan__Hiroshima(104, 321),
    Japan__Gunma(104, 320),
    Japan__Gifu(104, 319),
    Japan__Fukushima(104, 318),
    Japan__Fukuoka(104, 317),
    Japan__Fukui(104, 316),
    Japan__Ehime(104, 315),
    Japan__Chiba(104, 314),
    Japan__Aomori(104, 313),
    Japan__Akita(104, 383),
    Japan__Aichi(104, 312),
    Italy__Veneto(99, 209),
    Italy__Valle_d_Aosta(99, 208),
    Italy__Umbria(99, 207),
    Italy__Trentino_Alto_Adige(99, 206),
    Italy__Toscana(99, 205),
    Italy__Sicilia(99, 204),
    Italy__Sardegna(99, 203),
    Italy__Puglia(99, 202),
    Italy__Piemonte(99, 201),
    Italy__Molise(99, 200),
    Italy__Marche(99, 199),
    Italy__Lombardia(99, 198),
    Italy__Liguria(99, 197),
    Italy__Lazio(99, 196),
    Italy__Friuli_Venezia_Giulia(99, 195),
    Italy__Emilia_Romagna(99, 194),
    Italy__Campania(99, 193),
    Italy__Calabria(99, 192),
    Italy__Basilicata(99, 190),
    Italy__Abruzzo(99, 189),
    Ireland__Ulster(7, 224),
    Ireland__Munster(7, 225),
    Ireland__Leinster(7, 228),
    Ireland__Dublin(7, 226),
    Ireland__Connacht(7, 227),
    Hungary__Zala(92, 453),
    Hungary__Veszpr\u00e9m(92, 452),
    Hungary__Vas(92, 451),
    Hungary__Tolna(92, 450),
    Hungary__Szabolcs_Szatm\u00e1r_Bereg(92, 449),
    Hungary__Somogy(92, 448),
    Hungary__Pest(92, 447),
    Hungary__N\u00f3gr\u00e1d(92, 446),
    Hungary__Kom\u00e1rom_Esztergom(92, 445),
    Hungary__J\u00e1sz_Nagykun_Szolnok(92, 444),
    Hungary__Heves(92, 443),
    Hungary__Hajd\u00fa_Bihar(92, 442),
    Hungary__Gyor_Moson_Sopron(92, 441),
    Hungary__Fej\u00e9r(92, 440),
    Hungary__Csongr\u00e1d(92, 439),
    Hungary__Budapest(92, 438),
    Hungary__Borsod_Aba\u00faj_Zempl\u00e9n(92, 437),
    Hungary__B\u00e9k\u00e9s(92, 436),
    Hungary__Baranya(92, 435),
    Hungary__B\u00e1cs_Kiskun(92, 434),
    Germany__Th\u00fcringen(79, 149),
    Germany__Schleswig_Holstein(79, 148),
    Germany__Sachsen_Anhalt(79, 147),
    Germany__Sachsen(79, 146),
    Germany__Saarland(79, 145),
    Germany__Rheinland_Pfalz(79, 144),
    Germany__Nordrhein_Westfalen(79, 143),
    Germany__Niedersachsen(79, 142),
    Germany__Mecklenburg_Vorpommern(79, 141),
    Germany__Hessen(79, 150),
    Germany__Hamburg(79, 140),
    Germany__Bremen(79, 139),
    Germany__Brandenburg(79, 138),
    Germany__Berlin(79, 137),
    Germany__Bayern(79, 136),
    Germany__Baden_W\u00fcrttemberg(79, 135),
    France__Rh\u00f4ne_Alpes(73, 432),
    France__Provence_Alpes_C\u00f4te_d_Azur(73, 431),
    France__Poitou_Charentes(73, 430),
    France__Picardie(73, 429),
    France__Pays_de_la_Loire(73, 428),
    France__Nord_Pas_de_Calais(73, 427),
    France__Midi_Pyr\u00e9n\u00e9es(73, 426),
    France__Lorraine(73, 425),
    France__Limousin(73, 424),
    France__Languedoc_Roussillon(73, 423),
    France__\u00cele_de_France(73, 422),
    France__Haute_Normandie(73, 421),
    France__Franche_Comt\u00e9(73, 420),
    France__Corse(73, 419),
    France__Champagne_Ardenne(73, 418),
    France__Centre(73, 417),
    France__Bretagne(73, 416),
    France__Bourgogne(73, 415),
    France__Basse_Normandie(73, 414),
    France__Auvergne(73, 413),
    France__Aquitaine(73, 412),
    France__Alsace(73, 433),
    Czech_Republic__Zlinsky_kraj(56, 285),
    Czech_Republic__Ustecky_kraj(56, 283),
    Czech_Republic__Stredocesky_kraj(56, 282),
    Czech_Republic__Plzensky_kraj(56, 281),
    Czech_Republic__Pardubicky_kraj(56, 280),
    Czech_Republic__Olomoucky_kraj(56, 278),
    Czech_Republic__Moravskoslezsky_kraj(56, 279),
    Czech_Republic__Liberecky_kraj(56, 277),
    Czech_Republic__Kralovehradecky_kraj(56, 275),
    Czech_Republic__Kraj_Vysocina(56, 284),
    Czech_Republic__Karlovarsky_kraj(56, 276),
    Czech_Republic__Jihomoravsky_kraj(56, 273),
    Czech_Republic__Jihocesky_kraj(56, 274),
    Czech_Republic__Hlavni_mesto_Praha(56, 286),
    Canada__Yukon_Territory(5, 74),
    Canada__Saskatchewan(5, 71),
    Canada__Quebec(5, 62),
    Canada__Prince_Edward_Island(5, 70),
    Canada__Ontario(5, 69),
    Canada__Nunavut(5, 73),
    Canada__Nova_Scotia(5, 68),
    Canada__Northwest_Territories(5, 72),
    Canada__Newfoundland_and_Labrador(5, 67),
    Canada__New_Brunswick(5, 66),
    Canada__Manitoba(5, 65),
    Canada__British_Columbia(5, 64),
    Canada__Alberta(5, 63),
    Brazil__Tocantins(34, 188),
    Brazil__Sergipe(34, 187),
    Brazil__S\u00e3o_Paulo(34, 186),
    Brazil__Santa_Catarina(34, 185),
    Brazil__Roraima(34, 184),
    Brazil__Rond\u00f4nia(34, 183),
    Brazil__Rio_Grande_do_Sul(34, 182),
    Brazil__Rio_Grande_do_Norte(34, 181),
    Brazil__Rio_de_Janeiro(34, 180),
    Brazil__Piau\u00ed(34, 179),
    Brazil__Pernambuco(34, 178),
    Brazil__Paran\u00e1(34, 177),
    Brazil__Para\u00edba(34, 176),
    Brazil__Par\u00e1(34, 175),
    Brazil__Minas_Gerais(34, 174),
    Brazil__Mato_Grosso_do_Sul(34, 173),
    Brazil__Mato_Grosso(34, 172),
    Brazil__Maranh\u00e3o(34, 171),
    Brazil__Goi\u00e1s(34, 170),
    Brazil__Esp\u00edrito_Santo(34, 169),
    Brazil__Distrito_Federal(34, 168),
    Brazil__Cear\u00e1(34, 167),
    Brazil__Bahia(34, 166),
    Brazil__Amazonas(34, 165),
    Brazil__Amap\u00e1(34, 164),
    Brazil__Alagoas(34, 163),
    Brazil__Acre(34, 162),
    Belgium__West_Vlaanderen(4, 92),
    Belgium__Vlaams_Brabant(4, 78),
    Belgium__Oost_Vlaanderen(4, 76),
    Belgium__Namur(4, 81),
    Belgium__Luxembourg(4, 90),
    Belgium__Limburg(4, 89),
    Belgium__Li\u00e8ge(4, 80),
    Belgium__Hainaut(4, 88),
    Belgium__Brussels(4, 93),
    Belgium__Brabant_wallon(4, 91),
    Belgium__Antwerpen(4, 87),
    Austria__Wien(227, 295),
    Austria__Vorarlberg(227, 265),
    Austria__Tirol(227, 264),
    Austria__Steiermark(227, 263),
    Austria__Salzburg(227, 262),
    Austria__Ober\u00f6sterreich(227, 261),
    Austria__Nieder\u00f6sterreich(227, 260),
    Austria__K\u00e4rnten(227, 259),
    Austria__Burgenland(227, 258),
    Australia__Western_Australia(3, 56),
    Australia__Victoria(3, 53),
    Australia__Tasmania(3, 57),
    Australia__South_Australia(3, 55),
    Australia__Queensland(3, 54),
    Australia__Northern_Territory(3, 58),
    Australia__New_South_Wales(3, 52),
    Australia__Australian_Capital_Territory(3, 59);

    private final int code;
    private final GcCountry country;
    private final String compactName;

    private GcState(int countryCode, int code) {
        this.country = GcCountry.of(countryCode);
        this.code = code;
        this.compactName = this.name().replaceAll("_", "");
    }

    @Override
    public int code() {
        return this.code;
    }

    public GcCountry getCountry() {
        return this.country;
    }

    @Override
    public String compactName() {
        return this.compactName;
    }

    public String toString() {
        return this.name().replace("__", ": ").replaceAll("_", " ");
    }

    public static GcState ofCompact(String compactName) {
        return (GcState)GcReferential.ofCompact((String)compactName, (GcReferential[])GcState.values());
    }

    public static GcState of(String name) {
        name = name.trim().replaceAll("\\s", "_").replaceAll(":", "_").replaceAll("-", "_").replaceAll("'", "_").replaceAll("\\)", "_").replaceAll("/", "_").replaceAll("\\(", "_");
        for (GcState gcStates : GcState.values()) {
            if (!gcStates.name().equalsIgnoreCase(name)) continue;
            return gcStates;
        }
        throw new IllegalStateException(String.format("Can't find GcState for name: %s", name));
    }

    public static GcState of(int code) {
        for (GcState gcState : GcState.values()) {
            if (gcState.code() != code) continue;
            return gcState;
        }
        throw new IllegalStateException(String.format("Can't find GcState for code: %s", code));
    }
}

