/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcHelper;
import org.nuiton.util.sql.SqlFileReader;

public class GcJdbcHelper
extends JdbcHelper {
    public static final int BUZZER_SIZE = 100;

    GcJdbcHelper(JdbcConfiguration jdbcConfiguration) {
        super(jdbcConfiguration);
    }

    public void executeSql(File file) {
        try (BufferedReader bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            this.executeSql(bufferedReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeSql(InputStream file) {
        try (InputStreamReader bufferedReader = new InputStreamReader(file, StandardCharsets.UTF_8);){
            this.executeSql(bufferedReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeSql(Reader reader) {
        try (Connection connection = this.openConnection();
             Statement preparedStatement = connection.createStatement();){
            int statementCount = 0;
            StringBuilder currentStatement = null;
            for (String sqlStatement : new SqlFileReader(reader)) {
                if (sqlStatement.startsWith("--")) continue;
                if (sqlStatement.trim().endsWith(";")) {
                    if (currentStatement == null) {
                        preparedStatement.addBatch(sqlStatement);
                    } else {
                        currentStatement.append("\n").append(sqlStatement);
                        preparedStatement.addBatch(currentStatement.toString());
                        currentStatement = null;
                    }
                    ++statementCount;
                } else if (currentStatement == null) {
                    currentStatement = new StringBuilder(sqlStatement);
                } else {
                    currentStatement.append("\n").append(sqlStatement);
                }
                if (statementCount % 100 != 0) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

