/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum GcDifficulty {
    D1(1.0f),
    D1_5(1.5f),
    D2(2.0f),
    D2_5(2.5f),
    D3(3.0f),
    D3_5(3.5f),
    D4(4.0f),
    D4_5(4.5f),
    D5(5.0f);

    private final float code;

    private GcDifficulty(float code) {
        this.code = code;
    }

    public float getCode() {
        return this.code;
    }

    public String toString() {
        return this.name().substring(1).replace("_", ".");
    }

    public static List<GcDifficulty> reverseValues() {
        List<GcDifficulty> result = Arrays.asList(GcDifficulty.values());
        Collections.reverse(result);
        return result;
    }

    public static GcDifficulty valueOf(float code) {
        for (GcDifficulty gcDifficulty : GcDifficulty.values()) {
            if (code != gcDifficulty.code) continue;
            return gcDifficulty;
        }
        throw new IllegalStateException("Can't find difficulty with code: " + code);
    }
}

