/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import io.ultreia.gc.db.GcDbConfig;
import io.ultreia.gc.db.entity.AbstractGcDbTopiaApplicationContext;
import io.ultreia.gc.db.entity.GcJdbcHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hikaricp.internal.HikariCPConnectionProvider;
import org.nuiton.topia.persistence.BeanTopiaConfiguration;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.LegacyTopiaIdFactory;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcConfigurationBuilder;

public class GcDbTopiaApplicationContext
extends AbstractGcDbTopiaApplicationContext {
    private static final Log log = LogFactory.getLog(GcDbTopiaApplicationContext.class);
    private final GcJdbcHelper gcJdbcHelper;
    private final GcDbConfig config;

    public static synchronized GcDbTopiaApplicationContext create(String classifier, String ... args) {
        log.info((Object)String.format("Create db application context (classifier: %s), (args: %s)", classifier, Arrays.toString(args)));
        GcDbConfig config = new GcDbConfig(classifier, args);
        JdbcConfiguration jdbcConfiguration = new JdbcConfigurationBuilder().forDatabase(config.getJdbcUrl(), config.getJdbcLogin(), config.getJdbcPassword());
        BeanTopiaConfiguration topiaConfiguration = new BeanTopiaConfiguration(jdbcConfiguration);
        topiaConfiguration.setTopiaIdFactoryClass(LegacyTopiaIdFactory.class);
        topiaConfiguration.setValidateSchema(false);
        topiaConfiguration.setInitSchema(false);
        Map hibernateExtraConfiguration = topiaConfiguration.getHibernateExtraConfiguration();
        hibernateExtraConfiguration.put("hibernate.connection.provider_class", HikariCPConnectionProvider.class.getName());
        hibernateExtraConfiguration.put("hibernate.hikari.minimumIdle", "2");
        hibernateExtraConfiguration.put("hibernate.hikari.maximumPoolSize", "100");
        hibernateExtraConfiguration.put("hibernate.hikari.autoCommit", "false");
        hibernateExtraConfiguration.put("hibernate.hikari.registerMbeans", "true");
        return new GcDbTopiaApplicationContext((TopiaConfiguration)topiaConfiguration, config);
    }

    public void createSchema() {
        log.info((Object)"Create schema...");
        super.createSchema();
        log.info((Object)"Loading countries...");
        this.loadClassPathScript("/db/01_country.sql");
        log.info((Object)"Loading states...");
        this.loadClassPathScript("/db/02_state.sql");
        log.info((Object)"Loading attributes...");
        this.loadClassPathScript("/db/03_attribute.sql");
        log.info((Object)"Loading districts...");
        this.loadClassPathScript("/db/04_district.sql");
        log.info((Object)"Create postgis...");
        this.loadClassPathScript("/db/05_cache_postgis.sql");
        this.loadClassPathScript("/db/06_district_postgis.sql");
    }

    public GcDbTopiaApplicationContext(TopiaConfiguration topiaConfiguration, GcDbConfig config) {
        super(topiaConfiguration);
        this.config = config;
        this.gcJdbcHelper = new GcJdbcHelper((JdbcConfiguration)this.getConfiguration());
    }

    public GcDbConfig getConfig() {
        return this.config;
    }

    public GcJdbcHelper getGcJdbcHelper() {
        return this.gcJdbcHelper;
    }

    private void loadClassPathScript(String resourcePath) {
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);){
            this.getGcJdbcHelper().executeSql(inputStream);
        }
        catch (IOException e) {
            throw new TopiaException("Can't load class-path script: " + resourcePath, (Throwable)e);
        }
    }
}

