/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import io.ultreia.gc.db.entity.GcAttribute;
import io.ultreia.gc.db.entity.GcCache;
import io.ultreia.gc.db.entity.GcCacheAttribute;
import io.ultreia.gc.db.entity.GcCacheCountryStats;
import io.ultreia.gc.db.entity.GcCacheStateStats;
import io.ultreia.gc.db.entity.GcUser;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public enum GcDbEntityEnum implements TopiaEntityEnum
{
    GcAttribute(GcAttribute.class, null, "gcattribute", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
    GcCache(GcCache.class, null, "gccache", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
    GcCacheAttribute(GcCacheAttribute.class, null, "gccacheattribute", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
    GcCacheCountryStats(GcCacheCountryStats.class, null, "gccachecountrystats", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
    GcCacheStateStats(GcCacheStateStats.class, null, "gccachestatestats", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
    GcUser(GcUser.class, null, "gcuser", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]);

    private final Class<? extends TopiaEntity> contract;
    private final String dbSchemaName;
    private final String dbTableName;
    private String implementationFQN;
    private Class<? extends TopiaEntity> implementation;
    private final String[] naturalIds;
    private final String[] notNulls;

    private GcDbEntityEnum(Class<? extends TopiaEntity> contract, String dbSchemaName, String dbTableName, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.dbSchemaName = dbSchemaName;
        this.dbTableName = dbTableName;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        this.implementationFQN = contract.getName() + "Impl";
    }

    public Class<? extends TopiaEntity> getContract() {
        return this.contract;
    }

    public String dbSchemaName() {
        return this.dbSchemaName;
    }

    public String dbTableName() {
        return this.dbTableName;
    }

    public String[] getNaturalIds() {
        return this.naturalIds;
    }

    public boolean isUseNaturalIds() {
        return this.naturalIds.length > 0;
    }

    public String[] getNotNulls() {
        return this.notNulls;
    }

    public boolean isUseNotNulls() {
        return this.notNulls.length > 0;
    }

    public String getImplementationFQN() {
        return this.implementationFQN;
    }

    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        EntityOperatorStore.clear();
    }

    public boolean accept(Class<? extends TopiaEntity> klass) {
        GcDbEntityEnum constant = GcDbEntityEnum.valueOf(klass);
        boolean result = constant.getContract() == this.contract;
        return result;
    }

    public Class<? extends TopiaEntity> getImplementation() {
        if (this.implementation == null) {
            try {
                this.implementation = Class.forName(this.implementationFQN);
            }
            catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + this.implementationFQN, (Throwable)e);
            }
        }
        return this.implementation;
    }

    public static GcDbEntityEnum valueOf(TopiaEntity entity) {
        return GcDbEntityEnum.valueOf(entity.getClass());
    }

    public static GcDbEntityEnum valueOf(Class<?> klass) {
        if (klass.isInterface()) {
            return GcDbEntityEnum.valueOf(klass.getSimpleName());
        }
        Class contractClass = TopiaEntityHelper.getContractClass((TopiaEntityEnum[])GcDbEntityEnum.values(), klass);
        if (contractClass != null) {
            return GcDbEntityEnum.valueOf(contractClass.getSimpleName());
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])GcDbEntityEnum.values()));
    }

    public static GcDbEntityEnum[] getContracts() {
        GcDbEntityEnum[] result = GcDbEntityEnum.values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        GcDbEntityEnum constant = GcDbEntityEnum.valueOf(klass);
        Class<? extends TopiaEntity> result = constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        GcDbEntityEnum[] values = GcDbEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        GcDbEntityEnum constant = GcDbEntityEnum.valueOf(klass);
        Class<? extends TopiaEntity> result = constant.getImplementation();
        return result;
    }

    public static Set<Class<? extends TopiaEntity>> getImplementationClasses() {
        GcDbEntityEnum[] values = GcDbEntityEnum.values();
        LinkedHashSet<Class<? extends TopiaEntity>> result = new LinkedHashSet<Class<? extends TopiaEntity>>();
        for (int i = 0; i < values.length; ++i) {
            result.add(values[i].getImplementation());
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : GcDbEntityEnum.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }

    public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {
        GcDbEntityEnum constant = GcDbEntityEnum.valueOf(klass);
        EntityOperator result = EntityOperatorStore.getOperator((TopiaEntityEnum)constant);
        return result;
    }
}

