/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import javax.swing.ImageIcon;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public enum GcCacheType {
    TRADITIONNAL("Traditional Cache", 2),
    MULTI("Multi-cache", 3),
    VIRTUAL("Virtual Cache", 4),
    LETTERBOX("Letterbox Hybrid", 5),
    EVENT("Event Cache", 6),
    APE("Ape", 7),
    UNKNOWN("Unknown Cache", 8),
    APE2("Ape", 9),
    WEBCAM("Webcam Cache", 11),
    LOCATIONLESS("Locationess Cache", 12),
    CITO("Cache In Trash Out Event", 13),
    EARTHCACHE("Earthcache", 137),
    MEGA("Mega-Event Cache", 453),
    GPS("GPS Adventures Exhibit", 1304),
    WHEREIGO("Wherigo Cache", 1858),
    GIGA("Giga-Event Cache", 7005),
    HQ("Geocaching HQ Geocache", -1);

    private final int code;
    private final String label;
    private ImageIcon icon;

    private GcCacheType(String label, int code) {
        this.label = label;
        this.code = code;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = SwingUtil.createImageIcon((String)("type/" + this.code + ".gif"));
        }
        return this.icon;
    }

    public static GcCacheType of(String code) {
        for (GcCacheType gcCacheType : GcCacheType.values()) {
            if (!code.equals(gcCacheType.label)) continue;
            return gcCacheType;
        }
        try {
            Integer integer = Integer.valueOf(code);
            for (GcCacheType gcCacheType : GcCacheType.values()) {
                if (integer != gcCacheType.code) continue;
                return gcCacheType;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }
}

