/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import io.ultreia.gc.db.entity.AbstractGcCacheTopiaDao;
import io.ultreia.gc.db.entity.GcCache;
import io.ultreia.gc.db.entity.GcCacheRefWithCoordinates;
import io.ultreia.gc.db.entity.GcDistrict;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;

public class GcCacheTopiaDao
extends AbstractGcCacheTopiaDao<GcCache> {
    public Set<String> findAllGcNames() {
        return new LinkedHashSet<String>(this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<String>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement("select gcname from gccache order by gcname");
            }

            public String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        }));
    }

    public Set<String> findAllGcNames(final String cacheType, final boolean nullLastUpdate) {
        return new LinkedHashSet<String>(this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<String>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement(String.format("select gcname from gccache where gctype='%s' " + (nullLastUpdate ? " and lastUpdate is null" : "") + " order by gcname", cacheType));
            }

            public String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        }));
    }

    public Set<String> findAllFrenchGcNames() {
        return new LinkedHashSet<String>(this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<String>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement("select gcname from gccache where country='France' order by gcname");
            }

            public String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        }));
    }

    public Set<String> findAllGcNamesWithoutLogs() {
        return new LinkedHashSet<String>(this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<String>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement("select gcname from gccache where logsjson is null order by gcname");
            }

            public String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        }));
    }

    public void updateDistricts(Map<String, GcDistrict> result) {
        StringBuilder sqlBuilder = new StringBuilder();
        for (Map.Entry<String, GcDistrict> entry : result.entrySet()) {
            sqlBuilder.append(String.format("update gccache set district = '%s' where topiaid ='%s';\n", entry.getValue().name(), entry.getKey()));
        }
        this.topiaSqlSupport.executeSql(sqlBuilder.toString());
    }

    public void updateElevations(Map<String, Integer> result) {
        StringBuilder sqlBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : result.entrySet()) {
            sqlBuilder.append(String.format("update gccache set elevation = %d where topiaid ='%s';\n", entry.getValue(), entry.getKey()));
        }
        this.topiaSqlSupport.executeSql(sqlBuilder.toString());
    }

    public Set<GcCacheRefWithCoordinates> findFrenchGcNamesWithoutDistrict() {
        return new LinkedHashSet<GcCacheRefWithCoordinates>(this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<GcCacheRefWithCoordinates>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement("select topiaid, gcname, lat, lon from gccache where district is null and country = 'France' order by gcname");
            }

            public GcCacheRefWithCoordinates prepareResult(ResultSet set) throws SQLException {
                return new GcCacheRefWithCoordinates(set.getString(1), set.getString(2), set.getDouble(3), set.getDouble(4));
            }
        }));
    }

    public Set<GcCacheRefWithCoordinates> findGcNamesWithoutElevation() {
        return new LinkedHashSet<GcCacheRefWithCoordinates>(this.topiaSqlSupport.findMultipleResult((TopiaSqlQuery)new TopiaSqlQuery<GcCacheRefWithCoordinates>(){

            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement("select topiaid, gcname, lat, lon from gccache where elevation is null order by gcname");
            }

            public GcCacheRefWithCoordinates prepareResult(ResultSet set) throws SQLException {
                return new GcCacheRefWithCoordinates(set.getString(1), set.getString(2), set.getDouble(3), set.getDouble(4));
            }
        }));
    }
}

