/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db.entity;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ultreia.gc.db.entity.GcCacheLog;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class GcCacheLogAdapter
implements JsonDeserializer<GcCacheLog>,
JsonSerializer<GcCacheLog> {
    private static final SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyy");

    public GcCacheLog deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        GcCacheLog result = new GcCacheLog();
        JsonObject asJsonObject = json.getAsJsonObject();
        result.setLogId(asJsonObject.get("id").getAsInt());
        result.setLogGuid(asJsonObject.get("guid").getAsString());
        result.setLogText(asJsonObject.get("text").getAsString());
        result.setLogType(asJsonObject.get("type").getAsString());
        result.setUser(asJsonObject.get("user").getAsString());
        try {
            result.setLogDate(df.parse(asJsonObject.get("date").getAsString()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public JsonElement serialize(GcCacheLog src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add("id", context.serialize((Object)src.getLogId()));
        result.add("guid", context.serialize((Object)src.getLogGuid()));
        result.add("text", context.serialize((Object)src.getLogText()));
        result.add("type", context.serialize((Object)src.getLogType()));
        result.add("user", context.serialize((Object)src.getUser()));
        result.add("date", context.serialize((Object)df.format(src.getLogDate())));
        return result;
    }
}

