/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db;

import io.ultreia.gc.db.GcDbConfigOption;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

public abstract class GeneratedGcDbConfig
implements Supplier<ApplicationConfig> {
    private ApplicationConfig applicationConfig;

    protected GeneratedGcDbConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedGcDbConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])GcDbConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return this.applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getConfigFile() {
        return this.applicationConfig.getOption(GcDbConfigOption.CONFIG_FILE.getKey());
    }

    public void setConfigFile(String configFile) {
        this.setOption(GcDbConfigOption.CONFIG_FILE.getKey(), configFile);
    }

    public String getBuildDate() {
        return this.applicationConfig.getOption(GcDbConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {
        this.setOption(GcDbConfigOption.BUILD_DATE.getKey(), buildDate);
    }

    public String getBuildNumber() {
        return this.applicationConfig.getOption(GcDbConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {
        this.setOption(GcDbConfigOption.BUILD_NUMBER.getKey(), buildNumber);
    }

    public Version getBuildVersion() {
        return this.applicationConfig.getOptionAsVersion(GcDbConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {
        this.setOption(GcDbConfigOption.BUILD_VERSION.getKey(), buildVersion);
    }

    public String getClassifier() {
        return this.applicationConfig.getOption(GcDbConfigOption.CLASSIFIER.getKey());
    }

    public void setClassifier(String classifier) {
        this.setOption(GcDbConfigOption.CLASSIFIER.getKey(), classifier);
    }

    public File getDataDirectory() {
        return this.applicationConfig.getOptionAsFile(GcDbConfigOption.DATA_DIRECTORY.getKey());
    }

    public void setDataDirectory(File dataDirectory) {
        this.setOption(GcDbConfigOption.DATA_DIRECTORY.getKey(), dataDirectory);
    }

    public String getJdbcUrl() {
        return this.applicationConfig.getOption(GcDbConfigOption.JDBC_URL.getKey());
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.setOption(GcDbConfigOption.JDBC_URL.getKey(), jdbcUrl);
    }

    public String getJdbcLogin() {
        return this.applicationConfig.getOption(GcDbConfigOption.JDBC_LOGIN.getKey());
    }

    public void setJdbcLogin(String jdbcLogin) {
        this.setOption(GcDbConfigOption.JDBC_LOGIN.getKey(), jdbcLogin);
    }

    public String getJdbcPassword() {
        return this.applicationConfig.getOption(GcDbConfigOption.JDBC_PASSWORD.getKey());
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.setOption(GcDbConfigOption.JDBC_PASSWORD.getKey(), jdbcPassword);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", this.get().getConfigFileName()));
        for (GcDbConfigOption option : this.orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), this.get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcDbConfigOption> orderedByKey() {
        List<GcDbConfigOption> values = Arrays.asList(GcDbConfigOption.values());
        Collections.sort(values, new Comparator<GcDbConfigOption>(){

            @Override
            public int compare(GcDbConfigOption o1, GcDbConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }
}

