/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db;

import java.io.File;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

public enum GcDbConfigOption implements ConfigOptionDef
{
    CONFIG_FILE(String.class, "config.file", "Configuration filename", "gc-server${gc.classifier}.conf", true, false),
    BUILD_DATE(String.class, "gc.build.date", "Build date", null, true, false),
    BUILD_NUMBER(String.class, "gc.build.number", "Build Number", null, true, false),
    BUILD_VERSION(Version.class, "gc.build.version", "Build Version", null, true, false),
    CLASSIFIER(String.class, "gc.classifier", "Instance classifier", null, false, false),
    DATA_DIRECTORY(File.class, "gc.dataDirectory", "Data directory", "${user.home}/.gc", false, false),
    JDBC_URL(String.class, "gc.db.url", "Jdbc url", "jdbc:h2:file:${gc.dataDirectory}/db/gc;FILE_LOCK=file;LOG=0;MODE=postgresql;DEFAULT_LOCK_TIMEOUT=100;DB_CLOSE_DELAY=0;LOCK_MODE=3;TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0;CACHE_SIZE=65536;MVCC=true", false, false),
    JDBC_LOGIN(String.class, "gc.db.login", "Db login", "sa", false, false),
    JDBC_PASSWORD(String.class, "gc.db.password", "Db password", "sa", false, false);

    private final Class type;
    private final String key;
    private final String description;
    private String defaultValue;
    private boolean _transient;
    private boolean _final;

    private GcDbConfigOption(Class type, String key, String description, String defaultValue, boolean _transient, boolean _final) {
        this.type = type;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this._final = _final;
        this._transient = _transient;
    }

    public String getKey() {
        return this.key;
    }

    public Class getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }
}

