/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.db;

import io.ultreia.gc.db.ApplicationConfig2;
import io.ultreia.gc.db.GcDbConfigOption;
import io.ultreia.gc.db.GeneratedGcDbConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ApplicationConfigScope;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.topia.persistence.TopiaException;

public class GcDbConfig
extends GeneratedGcDbConfig {
    private static final Log log = LogFactory.getLog(GcDbConfig.class);

    public GcDbConfig(String classifier, String ... args) {
        log.info((Object)String.format("Create db config (classifier: %s) (args: %s)", classifier, Arrays.toString(args)));
        this.get().setDefaultOption(GcDbConfigOption.CLASSIFIER.getKey(), classifier);
        ApplicationConfig2 defaultConf = new ApplicationConfig2(ApplicationConfigInit.forScopes((ApplicationConfigScope[])new ApplicationConfigScope[]{ApplicationConfigScope.CLASS_PATH, ApplicationConfigScope.DEFAULTS, ApplicationConfigScope.OPTIONS}).setConfigFileName("gc-db.conf"));
        try {
            defaultConf.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new TopiaException((Throwable)e);
        }
        Properties properties = defaultConf.getProperties(ApplicationConfigScope.CLASS_PATH);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.get().setDefaultOption("" + entry.getKey(), "" + entry.getValue());
        }
        log.info((Object)String.format("Use %s configuration file", this.getConfigFile()));
        this.get().setConfigFileName(this.getConfigFile());
        try {
            this.get().parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new TopiaException((Throwable)e);
        }
        log.info((Object)String.format("db config is initialized:\n%s", this.getConfigurationDescription()));
    }
}

