package io.ultreia.gc.db.entity;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Nov 06 10:24:05 CET 2017")
public abstract class GeneratedGcCacheTopiaDao<E extends GcCache> extends AbstractGcDbTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) GcCache.class;
    }

    @Override
    public GcDbEntityEnum getTopiaEntityEnum() {
        return GcDbEntityEnum.GcCache;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            GcCacheAttributeTopiaDao dao = topiaDaoSupplier
                    .getDao(GcCacheAttribute.class, GcCacheAttributeTopiaDao.class);
            List<GcCacheAttribute> list = dao
                    .forProperties(GcCacheAttribute.PROPERTY_GC_CACHE, entity)
                    .findAll();
            for (GcCacheAttribute item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGcCache())) {
                    item.setGcCache(null);
                }
            
            }
        }

        {
            GcCacheAttributeTopiaDao dao = topiaDaoSupplier
                    .getDao(GcCacheAttribute.class, GcCacheAttributeTopiaDao.class);
            List<GcCacheAttribute> list = dao
                    .forProperties(GcCacheAttribute.PROPERTY_GC_CACHE, entity)
                    .findAll();
            for (GcCacheAttribute item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGcCache())) {
                    item.setGcCache(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_GC_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_GC_NAME, v);
        return result;
    }

    @Deprecated
    public E findByGcName(String v) {
        return forGcNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGcName(String v) {
        return forGcNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_GC_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_GC_ID, v);
        return result;
    }

    @Deprecated
    public E findByGcId(String v) {
        return forGcIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGcId(String v) {
        return forGcIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcUidIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_GC_UID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcUidEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_GC_UID, v);
        return result;
    }

    @Deprecated
    public E findByGcUid(String v) {
        return forGcUidEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGcUid(String v) {
        return forGcUidEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLatIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LAT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLatEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LAT, v);
        return result;
    }

    @Deprecated
    public E findByLat(double v) {
        return forLatEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLat(double v) {
        return forLatEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLonIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLonEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LON, v);
        return result;
    }

    @Deprecated
    public E findByLon(double v) {
        return forLonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLon(double v) {
        return forLonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOldLatIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_OLD_LAT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOldLatEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_OLD_LAT, v);
        return result;
    }

    @Deprecated
    public E findByOldLat(Double v) {
        return forOldLatEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOldLat(Double v) {
        return forOldLatEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOldLonIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_OLD_LON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOldLonEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_OLD_LON, v);
        return result;
    }

    @Deprecated
    public E findByOldLon(Double v) {
        return forOldLonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOldLon(Double v) {
        return forOldLonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTimeIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_TIME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTimeEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_TIME, v);
        return result;
    }

    @Deprecated
    public E findByTime(Date v) {
        return forTimeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTime(Date v) {
        return forTimeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_DESCRIPTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_DESCRIPTION, v);
        return result;
    }

    @Deprecated
    public E findByDescription(String v) {
        return forDescriptionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDescription(String v) {
        return forDescriptionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUrlIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_URL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUrlEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_URL, v);
        return result;
    }

    @Deprecated
    public E findByUrl(String v) {
        return forUrlEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUrl(String v) {
        return forUrlEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUrlnameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_URLNAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUrlnameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_URLNAME, v);
        return result;
    }

    @Deprecated
    public E findByUrlname(String v) {
        return forUrlnameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUrlname(String v) {
        return forUrlnameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_GC_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_GC_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByGcType(String v) {
        return forGcTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGcType(String v) {
        return forGcTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAvailableIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_AVAILABLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAvailableEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_AVAILABLE, v);
        return result;
    }

    @Deprecated
    public E findByAvailable(boolean v) {
        return forAvailableEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAvailable(boolean v) {
        return forAvailableEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArchivedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_ARCHIVED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArchivedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_ARCHIVED, v);
        return result;
    }

    @Deprecated
    public E findByArchived(boolean v) {
        return forArchivedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByArchived(boolean v) {
        return forArchivedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFavPointsIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_FAV_POINTS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFavPointsEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_FAV_POINTS, v);
        return result;
    }

    @Deprecated
    public E findByFavPoints(Integer v) {
        return forFavPointsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFavPoints(Integer v) {
        return forFavPointsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPremiumIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_PREMIUM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPremiumEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_PREMIUM, v);
        return result;
    }

    @Deprecated
    public E findByPremium(boolean v) {
        return forPremiumEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPremium(boolean v) {
        return forPremiumEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUserNoteIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_USER_NOTE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUserNoteEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_USER_NOTE, v);
        return result;
    }

    @Deprecated
    public E findByUserNote(boolean v) {
        return forUserNoteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUserNote(boolean v) {
        return forUserNoteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forShortDescIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_SHORT_DESC, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forShortDescEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_SHORT_DESC, v);
        return result;
    }

    @Deprecated
    public E findByShortDesc(String v) {
        return forShortDescEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByShortDesc(String v) {
        return forShortDescEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongDescIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LONG_DESC, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongDescEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LONG_DESC, v);
        return result;
    }

    @Deprecated
    public E findByLongDesc(String v) {
        return forLongDescEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLongDesc(String v) {
        return forLongDescEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHintIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_HINT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHintEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_HINT, v);
        return result;
    }

    @Deprecated
    public E findByHint(String v) {
        return forHintEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByHint(String v) {
        return forHintEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forShortDescHtmlIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_SHORT_DESC_HTML, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forShortDescHtmlEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_SHORT_DESC_HTML, v);
        return result;
    }

    @Deprecated
    public E findByShortDescHtml(boolean v) {
        return forShortDescHtmlEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByShortDescHtml(boolean v) {
        return forShortDescHtmlEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongDescHtmlIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LONG_DESC_HTML, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongDescHtmlEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LONG_DESC_HTML, v);
        return result;
    }

    @Deprecated
    public E findByLongDescHtml(boolean v) {
        return forLongDescHtmlEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLongDescHtml(boolean v) {
        return forLongDescHtmlEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContainerIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_CONTAINER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContainerEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_CONTAINER, v);
        return result;
    }

    @Deprecated
    public E findByContainer(String v) {
        return forContainerEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByContainer(String v) {
        return forContainerEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLogsJsonIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LOGS_JSON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLogsJsonEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LOGS_JSON, v);
        return result;
    }

    @Deprecated
    public E findByLogsJson(String v) {
        return forLogsJsonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLogsJson(String v) {
        return forLogsJsonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forElevationIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_ELEVATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forElevationEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_ELEVATION, v);
        return result;
    }

    @Deprecated
    public E findByElevation(Integer v) {
        return forElevationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByElevation(Integer v) {
        return forElevationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOwnerIn(Collection<GcUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_OWNER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOwnerEquals(GcUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_OWNER, v);
        return result;
    }

    @Deprecated
    public E findByOwner(GcUser v) {
        return forOwnerEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOwner(GcUser v) {
        return forOwnerEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCountryIn(Collection<GcCountry> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_COUNTRY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCountryEquals(GcCountry v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_COUNTRY, v);
        return result;
    }

    @Deprecated
    public E findByCountry(GcCountry v) {
        return forCountryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCountry(GcCountry v) {
        return forCountryEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStateIn(Collection<GcState> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_STATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStateEquals(GcState v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_STATE, v);
        return result;
    }

    @Deprecated
    public E findByState(GcState v) {
        return forStateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByState(GcState v) {
        return forStateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcCacheAttributeContains(GcCacheAttribute v) {
        return forContains(GcCache.PROPERTY_GC_CACHE_ATTRIBUTE, v);
    }

    @Deprecated
    public E findContainsGcCacheAttribute(GcCacheAttribute v) {
        return forGcCacheAttributeContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsGcCacheAttribute(GcCacheAttribute v) {
        return forGcCacheAttributeContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTerrainIn(Collection<GcTerrain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_TERRAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTerrainEquals(GcTerrain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_TERRAIN, v);
        return result;
    }

    @Deprecated
    public E findByTerrain(GcTerrain v) {
        return forTerrainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTerrain(GcTerrain v) {
        return forTerrainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDifficultyIn(Collection<GcDifficulty> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_DIFFICULTY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDifficultyEquals(GcDifficulty v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_DIFFICULTY, v);
        return result;
    }

    @Deprecated
    public E findByDifficulty(GcDifficulty v) {
        return forDifficultyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDifficulty(GcDifficulty v) {
        return forDifficultyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDistrictIn(Collection<GcDistrict> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_DISTRICT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDistrictEquals(GcDistrict v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_DISTRICT, v);
        return result;
    }

    @Deprecated
    public E findByDistrict(GcDistrict v) {
        return forDistrictEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDistrict(GcDistrict v) {
        return forDistrictEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastUpdateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LAST_UPDATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastUpdateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LAST_UPDATE, v);
        return result;
    }

    @Deprecated
    public E findByLastUpdate(Date v) {
        return forLastUpdateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLastUpdate(Date v) {
        return forLastUpdateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastLogsUpdateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCache.PROPERTY_LAST_LOGS_UPDATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastLogsUpdateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCache.PROPERTY_LAST_LOGS_UPDATE, v);
        return result;
    }

    @Deprecated
    public E findByLastLogsUpdate(Date v) {
        return forLastLogsUpdateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLastLogsUpdate(Date v) {
        return forLastLogsUpdateEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GcCacheAttribute.class) {
            GcCacheAttributeTopiaDao dao =
                topiaDaoSupplier.getDao(GcCacheAttribute.class, GcCacheAttributeTopiaDao.class);
            tmp = dao.forGcCacheEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(GcCacheAttribute.class, entity);
        if (!list.isEmpty()) {
            result.put(GcCacheAttribute.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getGcCacheAttribute() != null) {
              tmp.addAll(entity.getGcCacheAttribute());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGcCacheTopiaDao<E extends GcCache>
