package io.ultreia.gc.db.entity;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Nov 06 10:24:05 CET 2017")
public abstract class GeneratedGcCacheStateStatsTopiaDao<E extends GcCacheStateStats> extends AbstractGcDbTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) GcCacheStateStats.class;
    }

    @Override
    public GcDbEntityEnum getTopiaEntityEnum() {
        return GcDbEntityEnum.GcCacheStateStats;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTotalIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheStateStats.PROPERTY_TOTAL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTotalEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheStateStats.PROPERTY_TOTAL, v);
        return result;
    }

    @Deprecated
    public E findByTotal(int v) {
        return forTotalEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTotal(int v) {
        return forTotalEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCurrentIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheStateStats.PROPERTY_CURRENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCurrentEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheStateStats.PROPERTY_CURRENT, v);
        return result;
    }

    @Deprecated
    public E findByCurrent(int v) {
        return forCurrentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCurrent(int v) {
        return forCurrentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStateIn(Collection<GcState> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheStateStats.PROPERTY_STATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStateEquals(GcState v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheStateStats.PROPERTY_STATE, v);
        return result;
    }

    @Deprecated
    public E findByState(GcState v) {
        return forStateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByState(GcState v) {
        return forStateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTerrainIn(Collection<GcTerrain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheStateStats.PROPERTY_TERRAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTerrainEquals(GcTerrain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheStateStats.PROPERTY_TERRAIN, v);
        return result;
    }

    @Deprecated
    public E findByTerrain(GcTerrain v) {
        return forTerrainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTerrain(GcTerrain v) {
        return forTerrainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDifficultyIn(Collection<GcDifficulty> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheStateStats.PROPERTY_DIFFICULTY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDifficultyEquals(GcDifficulty v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheStateStats.PROPERTY_DIFFICULTY, v);
        return result;
    }

    @Deprecated
    public E findByDifficulty(GcDifficulty v) {
        return forDifficultyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDifficulty(GcDifficulty v) {
        return forDifficultyEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGcCacheStateStatsTopiaDao<E extends GcCacheStateStats>
