package io.ultreia.gc.db.entity;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Nov 06 10:24:05 CET 2017")
public abstract class GeneratedGcCacheAttributeTopiaDao<E extends GcCacheAttribute> extends AbstractGcDbTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) GcCacheAttribute.class;
    }

    @Override
    public GcDbEntityEnum getTopiaEntityEnum() {
        return GcDbEntityEnum.GcCacheAttribute;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIncIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheAttribute.PROPERTY_INC, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIncEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheAttribute.PROPERTY_INC, v);
        return result;
    }

    @Deprecated
    public E findByInc(int v) {
        return forIncEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInc(int v) {
        return forIncEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcAttributeIn(Collection<GcAttribute> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheAttribute.PROPERTY_GC_ATTRIBUTE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcAttributeEquals(GcAttribute v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheAttribute.PROPERTY_GC_ATTRIBUTE, v);
        return result;
    }

    @Deprecated
    public E findByGcAttribute(GcAttribute v) {
        return forGcAttributeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGcAttribute(GcAttribute v) {
        return forGcAttributeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcCacheIn(Collection<GcCache> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcCacheAttribute.PROPERTY_GC_CACHE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGcCacheEquals(GcCache v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcCacheAttribute.PROPERTY_GC_CACHE, v);
        return result;
    }

    @Deprecated
    public E findByGcCache(GcCache v) {
        return forGcCacheEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGcCache(GcCache v) {
        return forGcCacheEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GcCache.class) {
            GcCacheTopiaDao dao =
                topiaDaoSupplier.getDao(GcCache.class, GcCacheTopiaDao.class);
            tmp = dao.forGcCacheAttributeContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(GcCache.class, entity);
        if (!list.isEmpty()) {
            result.put(GcCache.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGcCacheAttributeTopiaDao<E extends GcCacheAttribute>
