package io.ultreia.gc.db.entity;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Nov 06 10:24:05 CET 2017")
public abstract class GeneratedGcAttributeTopiaDao<E extends GcAttribute> extends AbstractGcDbTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) GcAttribute.class;
    }

    @Override
    public GcDbEntityEnum getTopiaEntityEnum() {
        return GcDbEntityEnum.GcAttribute;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            GcCacheAttributeTopiaDao dao = topiaDaoSupplier
                    .getDao(GcCacheAttribute.class, GcCacheAttributeTopiaDao.class);
            List<GcCacheAttribute> list = dao
                    .forProperties(GcCacheAttribute.PROPERTY_GC_ATTRIBUTE, entity)
                    .findAll();
            for (GcCacheAttribute item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGcAttribute())) {
                    item.setGcAttribute(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcAttribute.PROPERTY_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcAttribute.PROPERTY_ID, v);
        return result;
    }

    @Deprecated
    public E findById(String v) {
        return forIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllById(String v) {
        return forIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcAttribute.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcAttribute.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(int v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(int v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTextIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GcAttribute.PROPERTY_TEXT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTextEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GcAttribute.PROPERTY_TEXT, v);
        return result;
    }

    @Deprecated
    public E findByText(String v) {
        return forTextEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByText(String v) {
        return forTextEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GcCacheAttribute.class) {
            GcCacheAttributeTopiaDao dao =
                topiaDaoSupplier.getDao(GcCacheAttribute.class, GcCacheAttributeTopiaDao.class);
            tmp = dao.forGcAttributeEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(GcCacheAttribute.class, entity);
        if (!list.isEmpty()) {
            result.put(GcCacheAttribute.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGcAttributeTopiaDao<E extends GcAttribute>
