package io.ultreia.gc.db.entity;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Mon Nov 06 10:24:05 CET 2017")
public abstract class GcCacheAbstract extends AbstractTopiaEntity implements GcCache {

    /**
     * Nom de l'attribut en BD : gcName
     */
    protected String gcName;

    /**
     * Nom de l'attribut en BD : gcId
     */
    protected String gcId;

    /**
     * Nom de l'attribut en BD : gcUid
     */
    protected String gcUid;

    /**
     * Nom de l'attribut en BD : lat
     */
    protected double lat;

    /**
     * Nom de l'attribut en BD : lon
     */
    protected double lon;

    /**
     * Nom de l'attribut en BD : oldLat
     */
    protected Double oldLat;

    /**
     * Nom de l'attribut en BD : oldLon
     */
    protected Double oldLon;

    /**
     * Nom de l'attribut en BD : time
     */
    protected Date time;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : url
     */
    protected String url;

    /**
     * Nom de l'attribut en BD : urlname
     */
    protected String urlname;

    /**
     * Nom de l'attribut en BD : gcType
     */
    protected String gcType;

    /**
     * Nom de l'attribut en BD : available
     */
    protected boolean available;

    /**
     * Nom de l'attribut en BD : archived
     */
    protected boolean archived;

    /**
     * Nom de l'attribut en BD : favPoints
     */
    protected Integer favPoints;

    /**
     * Nom de l'attribut en BD : premium
     */
    protected boolean premium;

    /**
     * Nom de l'attribut en BD : userNote
     */
    protected boolean userNote;

    /**
     * Nom de l'attribut en BD : shortDesc
     */
    protected String shortDesc;

    /**
     * Nom de l'attribut en BD : longDesc
     */
    protected String longDesc;

    /**
     * Nom de l'attribut en BD : hint
     */
    protected String hint;

    /**
     * Nom de l'attribut en BD : shortDescHtml
     */
    protected boolean shortDescHtml;

    /**
     * Nom de l'attribut en BD : longDescHtml
     */
    protected boolean longDescHtml;

    /**
     * Nom de l'attribut en BD : container
     */
    protected String container;

    /**
     * Nom de l'attribut en BD : logsJson
     */
    protected String logsJson;

    /**
     * Nom de l'attribut en BD : elevation
     */
    protected Integer elevation;

    /**
     * Nom de l'attribut en BD : owner
     */
    protected GcUser owner;

    /**
     * Nom de l'attribut en BD : country
     */
    protected GcCountry country;

    /**
     * Nom de l'attribut en BD : state
     */
    protected GcState state;

    /**
     * Nom de l'attribut en BD : gcCacheAttribute
     */
    protected Collection<GcCacheAttribute> gcCacheAttribute;

    /**
     * Nom de l'attribut en BD : terrain
     */
    protected GcTerrain terrain;

    /**
     * Nom de l'attribut en BD : difficulty
     */
    protected GcDifficulty difficulty;

    /**
     * Nom de l'attribut en BD : district
     */
    protected GcDistrict district;

    /**
     * Nom de l'attribut en BD : lastUpdate
     */
    protected Date lastUpdate;

    /**
     * Nom de l'attribut en BD : lastLogsUpdate
     */
    protected Date lastLogsUpdate;

    private static final long serialVersionUID = 7233173764391134817L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_GC_NAME, String.class, gcName);
        visitor.visit(this, PROPERTY_GC_ID, String.class, gcId);
        visitor.visit(this, PROPERTY_GC_UID, String.class, gcUid);
        visitor.visit(this, PROPERTY_LAT, double.class, lat);
        visitor.visit(this, PROPERTY_LON, double.class, lon);
        visitor.visit(this, PROPERTY_OLD_LAT, Double.class, oldLat);
        visitor.visit(this, PROPERTY_OLD_LON, Double.class, oldLon);
        visitor.visit(this, PROPERTY_TIME, Date.class, time);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_URL, String.class, url);
        visitor.visit(this, PROPERTY_URLNAME, String.class, urlname);
        visitor.visit(this, PROPERTY_GC_TYPE, String.class, gcType);
        visitor.visit(this, PROPERTY_AVAILABLE, boolean.class, available);
        visitor.visit(this, PROPERTY_ARCHIVED, boolean.class, archived);
        visitor.visit(this, PROPERTY_FAV_POINTS, Integer.class, favPoints);
        visitor.visit(this, PROPERTY_PREMIUM, boolean.class, premium);
        visitor.visit(this, PROPERTY_USER_NOTE, boolean.class, userNote);
        visitor.visit(this, PROPERTY_SHORT_DESC, String.class, shortDesc);
        visitor.visit(this, PROPERTY_LONG_DESC, String.class, longDesc);
        visitor.visit(this, PROPERTY_HINT, String.class, hint);
        visitor.visit(this, PROPERTY_SHORT_DESC_HTML, boolean.class, shortDescHtml);
        visitor.visit(this, PROPERTY_LONG_DESC_HTML, boolean.class, longDescHtml);
        visitor.visit(this, PROPERTY_CONTAINER, String.class, container);
        visitor.visit(this, PROPERTY_LOGS_JSON, String.class, logsJson);
        visitor.visit(this, PROPERTY_ELEVATION, Integer.class, elevation);
        visitor.visit(this, PROPERTY_OWNER, GcUser.class, owner);
        visitor.visit(this, PROPERTY_COUNTRY, GcCountry.class, country);
        visitor.visit(this, PROPERTY_STATE, GcState.class, state);
        visitor.visit(this, PROPERTY_GC_CACHE_ATTRIBUTE, Collection.class, GcCacheAttribute.class, gcCacheAttribute);
        visitor.visit(this, PROPERTY_TERRAIN, GcTerrain.class, terrain);
        visitor.visit(this, PROPERTY_DIFFICULTY, GcDifficulty.class, difficulty);
        visitor.visit(this, PROPERTY_DISTRICT, GcDistrict.class, district);
        visitor.visit(this, PROPERTY_LAST_UPDATE, Date.class, lastUpdate);
        visitor.visit(this, PROPERTY_LAST_LOGS_UPDATE, Date.class, lastLogsUpdate);
    }

    @Override
    public void setGcName(String gcName) {
        this.gcName = gcName;
    }

    @Override
    public String getGcName() {
        String result = this.gcName;
        return result;
    }

    @Override
    public void setGcId(String gcId) {
        this.gcId = gcId;
    }

    @Override
    public String getGcId() {
        String result = this.gcId;
        return result;
    }

    @Override
    public void setGcUid(String gcUid) {
        this.gcUid = gcUid;
    }

    @Override
    public String getGcUid() {
        String result = this.gcUid;
        return result;
    }

    @Override
    public void setLat(double lat) {
        this.lat = lat;
    }

    @Override
    public double getLat() {
        double result = this.lat;
        return result;
    }

    @Override
    public void setLon(double lon) {
        this.lon = lon;
    }

    @Override
    public double getLon() {
        double result = this.lon;
        return result;
    }

    @Override
    public void setOldLat(Double oldLat) {
        this.oldLat = oldLat;
    }

    @Override
    public Double getOldLat() {
        Double result = this.oldLat;
        return result;
    }

    @Override
    public void setOldLon(Double oldLon) {
        this.oldLon = oldLon;
    }

    @Override
    public Double getOldLon() {
        Double result = this.oldLon;
        return result;
    }

    @Override
    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public Date getTime() {
        Date result = this.time;
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        String result = this.description;
        return result;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        String result = this.url;
        return result;
    }

    @Override
    public void setUrlname(String urlname) {
        this.urlname = urlname;
    }

    @Override
    public String getUrlname() {
        String result = this.urlname;
        return result;
    }

    @Override
    public void setGcType(String gcType) {
        this.gcType = gcType;
    }

    @Override
    public String getGcType() {
        String result = this.gcType;
        return result;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public boolean isAvailable() {
        boolean result = this.available;
        return result;
    }

    @Override
    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    @Override
    public boolean isArchived() {
        boolean result = this.archived;
        return result;
    }

    @Override
    public void setFavPoints(Integer favPoints) {
        this.favPoints = favPoints;
    }

    @Override
    public Integer getFavPoints() {
        Integer result = this.favPoints;
        return result;
    }

    @Override
    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    @Override
    public boolean isPremium() {
        boolean result = this.premium;
        return result;
    }

    @Override
    public void setUserNote(boolean userNote) {
        this.userNote = userNote;
    }

    @Override
    public boolean isUserNote() {
        boolean result = this.userNote;
        return result;
    }

    @Override
    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    @Override
    public String getShortDesc() {
        String result = this.shortDesc;
        return result;
    }

    @Override
    public void setLongDesc(String longDesc) {
        this.longDesc = longDesc;
    }

    @Override
    public String getLongDesc() {
        String result = this.longDesc;
        return result;
    }

    @Override
    public void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    public String getHint() {
        String result = this.hint;
        return result;
    }

    @Override
    public void setShortDescHtml(boolean shortDescHtml) {
        this.shortDescHtml = shortDescHtml;
    }

    @Override
    public boolean isShortDescHtml() {
        boolean result = this.shortDescHtml;
        return result;
    }

    @Override
    public void setLongDescHtml(boolean longDescHtml) {
        this.longDescHtml = longDescHtml;
    }

    @Override
    public boolean isLongDescHtml() {
        boolean result = this.longDescHtml;
        return result;
    }

    @Override
    public void setContainer(String container) {
        this.container = container;
    }

    @Override
    public String getContainer() {
        String result = this.container;
        return result;
    }

    @Override
    public void setLogsJson(String logsJson) {
        this.logsJson = logsJson;
    }

    @Override
    public String getLogsJson() {
        String result = this.logsJson;
        return result;
    }

    @Override
    public void setElevation(Integer elevation) {
        this.elevation = elevation;
    }

    @Override
    public Integer getElevation() {
        Integer result = this.elevation;
        return result;
    }

    @Override
    public void setOwner(GcUser owner) {
        this.owner = owner;
    }

    @Override
    public GcUser getOwner() {
        GcUser result = this.owner;
        return result;
    }

    @Override
    public void setCountry(GcCountry country) {
        this.country = country;
    }

    @Override
    public GcCountry getCountry() {
        GcCountry result = this.country;
        return result;
    }

    @Override
    public void setState(GcState state) {
        this.state = state;
    }

    @Override
    public GcState getState() {
        GcState result = this.state;
        return result;
    }

    @Override
    public void addGcCacheAttribute(GcCacheAttribute gcCacheAttribute) {
        if (this.gcCacheAttribute == null) {
            this.gcCacheAttribute = new LinkedList<GcCacheAttribute>();
        }
        gcCacheAttribute.setGcCache(this);
        this.gcCacheAttribute.add(gcCacheAttribute);
    }

    @Override
    public void addAllGcCacheAttribute(Iterable<GcCacheAttribute> gcCacheAttribute) {
        if (gcCacheAttribute == null) {
            return;
        }
        for (GcCacheAttribute item : gcCacheAttribute) {
            addGcCacheAttribute(item);
        }
    }

    @Override
    public void setGcCacheAttribute(Collection<GcCacheAttribute> gcCacheAttribute) {
        this.gcCacheAttribute = gcCacheAttribute;
    }

    @Override
    public void removeGcCacheAttribute(GcCacheAttribute gcCacheAttribute) {
        if (this.gcCacheAttribute == null || !this.gcCacheAttribute.remove(gcCacheAttribute)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        gcCacheAttribute.setGcCache(null);
    }

    @Override
    public void clearGcCacheAttribute() {
        if (this.gcCacheAttribute == null) {
            return;
        }
        for (GcCacheAttribute item : this.gcCacheAttribute) {
            item.setGcCache(null);
        }
        this.gcCacheAttribute.clear();
    }

    @Override
    public Collection<GcCacheAttribute> getGcCacheAttribute() {
        return gcCacheAttribute;
    }

    @Override
    public GcCacheAttribute getGcCacheAttributeByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(gcCacheAttribute, topiaId);
    }

    @Override
    public Collection<String> getGcCacheAttributeTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<io.ultreia.gc.db.entity.GcCacheAttribute> tmp = getGcCacheAttribute();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeGcCacheAttribute() {
        if (gcCacheAttribute == null) {
            return 0;
        }
        return gcCacheAttribute.size();
    }

    @Override
    public boolean isGcCacheAttributeEmpty() {
        int size = sizeGcCacheAttribute();
        return size == 0;
    }

    @Override
    public boolean isGcCacheAttributeNotEmpty() {
        boolean empty = isGcCacheAttributeEmpty();
        return ! empty;
    }

    @Override
    public boolean containsGcCacheAttribute(GcCacheAttribute gcCacheAttribute) {
        boolean contains = this.gcCacheAttribute !=null && this.gcCacheAttribute.contains(gcCacheAttribute);
        return contains;
    }

    @Override
    public void setTerrain(GcTerrain terrain) {
        this.terrain = terrain;
    }

    @Override
    public GcTerrain getTerrain() {
        GcTerrain result = this.terrain;
        return result;
    }

    @Override
    public void setDifficulty(GcDifficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public GcDifficulty getDifficulty() {
        GcDifficulty result = this.difficulty;
        return result;
    }

    @Override
    public void setDistrict(GcDistrict district) {
        this.district = district;
    }

    @Override
    public GcDistrict getDistrict() {
        GcDistrict result = this.district;
        return result;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public Date getLastUpdate() {
        Date result = this.lastUpdate;
        return result;
    }

    @Override
    public void setLastLogsUpdate(Date lastLogsUpdate) {
        this.lastLogsUpdate = lastLogsUpdate;
    }

    @Override
    public Date getLastLogsUpdate() {
        Date result = this.lastLogsUpdate;
        return result;
    }

} //GcCacheAbstract
