package io.ultreia.gc.db.entity;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnumProvider;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContextConstructorParameter;
import org.nuiton.topia.persistence.util.EntityOperator;

@Generated(value = "org.nuiton.topia.templates.ApplicationContextTransformer", date = "Mon Nov 06 10:24:05 CET 2017")
public abstract class AbstractGcDbTopiaApplicationContext extends AbstractTopiaApplicationContext<GcDbTopiaPersistenceContext> implements TopiaEntityEnumProvider<GcDbEntityEnum> {

    @Deprecated
    protected AbstractGcDbTopiaApplicationContext(Properties properties) {
        super(properties);
    }

    @Deprecated
    protected AbstractGcDbTopiaApplicationContext(Map<String, String> configuration) {
        super(configuration);
    }

    protected AbstractGcDbTopiaApplicationContext(TopiaConfiguration topiaConfiguration) {
        super(topiaConfiguration);
    }

    @Override
    public GcDbTopiaPersistenceContext newPersistenceContext() {

        GcDbTopiaPersistenceContext newContext = new GcDbTopiaPersistenceContext(
                new AbstractTopiaPersistenceContextConstructorParameter(
                        getHibernateProvider(),
                        getTopiaFiresSupport(),
                        getTopiaIdFactory(),
                        getSessionRegistry()
                )
        );
        registerPersistenceContext(newContext);
        return newContext;
    }

    @Override
    public String getModelVersion() {
        return "@gc.db.model.version@";
    }

    @Override
    public String getModelName() {
        return "GcDb";
    }

    @Override
    public <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        return GcDbEntityEnum.getContractClass(klass);
    }

    @Override
    public Class<? extends TopiaEntity>[] getContractClasses() {
        return GcDbEntityEnum.getContractClasses();
    }

    @Override
    public <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        return GcDbEntityEnum.getImplementationClass(klass);
    }

    @Override
    public Set<Class<? extends TopiaEntity>> getImplementationClasses() {
        return GcDbEntityEnum.getImplementationClasses();
    }

    public GcDbEntityEnum[] getContracts() {
        return GcDbEntityEnum.getContracts();
    }

    public <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {
        return GcDbEntityEnum.getOperator(klass);
    }

    @Override
    public <E extends TopiaEntity> GcDbEntityEnum getEntityEnum(Class<E> type) {
        return GcDbEntityEnum.valueOf(type);
    }

    @Override
    public GcDbEntityEnum getEntityEnum(String name) {
        return GcDbEntityEnum.valueOf(name);
    }

} //AbstractGcDbTopiaApplicationContext
