package io.ultreia.gc.db;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Generated;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.version.Version;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Mon Nov 06 10:24:11 CET 2017")
public abstract class GeneratedGcDbConfig implements Supplier<ApplicationConfig> {

    private ApplicationConfig applicationConfig;

    protected GeneratedGcDbConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedGcDbConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions(GcDbConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getConfigFile() {
        return applicationConfig.getOption(GcDbConfigOption.CONFIG_FILE.getKey());
    }

    public void setConfigFile(String configFile) {    setOption(GcDbConfigOption.CONFIG_FILE.getKey(), configFile);
    }

    public String getBuildDate() {
        return applicationConfig.getOption(GcDbConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {    setOption(GcDbConfigOption.BUILD_DATE.getKey(), buildDate);
    }

    public String getBuildNumber() {
        return applicationConfig.getOption(GcDbConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {    setOption(GcDbConfigOption.BUILD_NUMBER.getKey(), buildNumber);
    }

    public Version getBuildVersion() {
        return applicationConfig.getOptionAsVersion(GcDbConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {    setOption(GcDbConfigOption.BUILD_VERSION.getKey(), buildVersion);
    }

    public String getClassifier() {
        return applicationConfig.getOption(GcDbConfigOption.CLASSIFIER.getKey());
    }

    public void setClassifier(String classifier) {    setOption(GcDbConfigOption.CLASSIFIER.getKey(), classifier);
    }

    public File getDataDirectory() {
        return applicationConfig.getOptionAsFile(GcDbConfigOption.DATA_DIRECTORY.getKey());
    }

    public void setDataDirectory(File dataDirectory) {    setOption(GcDbConfigOption.DATA_DIRECTORY.getKey(), dataDirectory);
    }

    public String getJdbcUrl() {
        return applicationConfig.getOption(GcDbConfigOption.JDBC_URL.getKey());
    }

    public void setJdbcUrl(String jdbcUrl) {    setOption(GcDbConfigOption.JDBC_URL.getKey(), jdbcUrl);
    }

    public String getJdbcLogin() {
        return applicationConfig.getOption(GcDbConfigOption.JDBC_LOGIN.getKey());
    }

    public void setJdbcLogin(String jdbcLogin) {    setOption(GcDbConfigOption.JDBC_LOGIN.getKey(), jdbcLogin);
    }

    public String getJdbcPassword() {
        return applicationConfig.getOption(GcDbConfigOption.JDBC_PASSWORD.getKey());
    }

    public void setJdbcPassword(String jdbcPassword) {    setOption(GcDbConfigOption.JDBC_PASSWORD.getKey(), jdbcPassword);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", get().getConfigFileName()));
        for (GcDbConfigOption option : orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcDbConfigOption> orderedByKey() {
        List<GcDbConfigOption> values = Arrays.asList(GcDbConfigOption.values());
        Collections.sort(values, new Comparator<GcDbConfigOption>() {
            @Override
            public int compare(GcDbConfigOption o1, GcDbConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }

} //GeneratedGcDbConfig
