package io.ultreia.gc.db;

/*-
 * #%L
 * GC toolkit :: DB
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import javax.annotation.Generated;
import org.nuiton.config.ConfigOptionDef;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Mon Nov 06 10:24:04 CET 2017")

public enum GcDbConfigOption implements ConfigOptionDef {
    
    CONFIG_FILE(
        java.lang.String.class,
        "config.file",
        "Configuration filename",
        "gc-server${gc.classifier}.conf",
        true,
        false),
    
    BUILD_DATE(
        java.lang.String.class,
        "gc.build.date",
        "Build date",
        null,
        true,
        false),
    
    BUILD_NUMBER(
        java.lang.String.class,
        "gc.build.number",
        "Build Number",
        null,
        true,
        false),
    
    BUILD_VERSION(
        org.nuiton.version.Version.class,
        "gc.build.version",
        "Build Version",
        null,
        true,
        false),
    
    CLASSIFIER(
        java.lang.String.class,
        "gc.classifier",
        "Instance classifier",
        null,
        false,
        false),
    
    DATA_DIRECTORY(
        java.io.File.class,
        "gc.dataDirectory",
        "Data directory",
        "${user.home}/.gc",
        false,
        false),
    
    JDBC_URL(
        java.lang.String.class,
        "gc.db.url",
        "Jdbc url",
        "jdbc:h2:file:${gc.dataDirectory}/db/gc;FILE_LOCK=file;LOG=0;MODE=postgresql;DEFAULT_LOCK_TIMEOUT=100;DB_CLOSE_DELAY=0;LOCK_MODE=3;TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0;CACHE_SIZE=65536;MVCC=true",
        false,
        false),
    
    JDBC_LOGIN(
        java.lang.String.class,
        "gc.db.login",
        "Db login",
        "sa",
        false,
        false),
    
    JDBC_PASSWORD(
        java.lang.String.class,
        "gc.db.password",
        "Db password",
        "sa",
        false,
        false);

    private final Class type;

    private final String key;

    private final String description;

    private String defaultValue;

    private boolean _transient;

    private boolean _final;

    GcDbConfigOption(Class type, String key, String description, String defaultValue, boolean _transient, boolean _final) {
        this.type = type;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this._final = _final;
        this._transient = _transient;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isTransient() {
        return _transient;
    }

    @Override
    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    @Override
    public boolean isFinal() {
        return _final;
    }

    @Override
    public void setFinal(boolean _final) {
        this._final = _final;
    }

} //GcDbConfigOption
