---
-- #%L
-- GC toolkit :: DB
-- %%
-- Copyright (C) 2017 Ultreia.io
-- %%
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public
-- License along with this program.  If not, see
-- <http://www.gnu.org/licenses/gpl-3.0.html>.
-- #L%
---

create table GcState ( id varchar(100) not null constraint gccstate_pkey primary key, country varchar(100) not null , code integer not null, name varchar(100) not null ) ;
alter TABLE GcState add CONSTRAINT u_gcstate_code UNIQUE(code);
alter TABLE GcState add CONSTRAINT u_gcstate_name UNIQUE(name);
alter table GcState add CONSTRAINT fk_gcstate_country FOREIGN KEY (country) REFERENCES gccountry(id);

INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Wyoming',51,  'United States: Wyoming');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Wisconsin',50,  'United States: Wisconsin');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__West_Virginia', 49,  'United States: West Virginia');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Washington',48,  'United States: Washington');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Virginia',47,  'United States: Virginia');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Vermont',46,  'United States: Vermont');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Utah',45,  'United States: Utah');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Texas',44,  'United States: Texas');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Tennessee',43,  'United States: Tennessee');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__South_Dakota', 42,  'United States: South Dakota');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__South_Carolina', 41,  'United States: South Carolina');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Rhode_Island', 40,  'United States: Rhode Island');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Pennsylvania',39,  'United States: Pennsylvania');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Oregon',38,  'United States: Oregon');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Oklahoma',37,  'United States: Oklahoma');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Ohio',36,  'United States: Ohio');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__North_Dakota', 35,  'United States: North Dakota');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__North_Carolina', 34,  'United States: North Carolina');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__New_York', 33,  'United States: New York');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__New_Mexico', 32,  'United States: New Mexico');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__New_Jersey', 31,  'United States: New Jersey');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__New_Hampshire', 30,  'United States: New Hampshire');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Nevada',29,  'United States: Nevada');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Nebraska',28,  'United States: Nebraska');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Montana',27,  'United States: Montana');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Missouri',26,  'United States: Missouri');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Mississippi',25,  'United States: Mississippi');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Minnesota',24,  'United States: Minnesota');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Michigan',23,  'United States: Michigan');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Massachusetts',22,  'United States: Massachusetts');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Maryland',21,  'United States: Maryland');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Maine',20,  'United States: Maine');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Louisiana',19,  'United States: Louisiana');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Kentucky',18,  'United States: Kentucky');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Kansas',17,  'United States: Kansas');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Iowa',16,  'United States: Iowa');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Indiana',15,  'United States: Indiana');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Illinois',14,  'United States: Illinois');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Idaho',13,  'United States: Idaho');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Hawaii',12,  'United States: Hawaii');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Georgia',11,  'United States: Georgia');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Florida',10,  'United States: Florida');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__District_of_Columbia', 8,  'United States: District of Columbia');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Delaware',9,  'United States: Delaware');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Connecticut',7,  'United States: Connecticut');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Colorado',6,  'United States: Colorado');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__California',5,  'United States: California');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Arkansas',4,  'United States: Arkansas');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Arizona',3,  'United States: Arizona');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Alaska',2,  'United States: Alaska');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_States', 'United_States__Alabama',60,  'United States: Alabama');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Yorkshire',214,  'United Kingdom: Yorkshire');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__West_Midlands', 216,  'United Kingdom: West Midlands');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Southern_Scotland', 211,  'United Kingdom: Southern Scotland');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Southern_England', 221,  'United Kingdom: Southern England');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__South_West_England', 222,  'United Kingdom: South West England');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__South_Wales', 218,  'United Kingdom: South Wales');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__South_East_England', 223,  'United Kingdom: South East England');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Northwest_England', 213,  'United Kingdom: Northwest England');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Northern_Scotland', 210,  'United Kingdom: Northern Scotland');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Northeast_England', 212,  'United Kingdom: Northeast England');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__North_Wales', 217,  'United Kingdom: North Wales');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__London',220,  'United Kingdom: London');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__Eastern_England', 219,  'United Kingdom: Eastern England');
INSERT INTO GcState (country, id,  code, name) VALUES ('United_Kingdom', 'United_Kingdom__East_Midlands', 215,  'United Kingdom: East Midlands');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Zentralschweiz__ZG_SZ_LU_UR_OW_NW_', 233,  'Switzerland: Zentralschweiz (ZG/SZ/LU/UR/OW/NW)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Wallis__VS_', 237,  'Switzerland: Wallis (VS)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Tessin__TI_', 238,  'Switzerland: Tessin (TI)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Suisse_romande__GE_VD_FR_', 235,  'Switzerland: Suisse romande (GE/VD/FR)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Region_Zuerich__ZH_', 231,  'Switzerland: Region Zuerich (ZH)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Ostschweiz__SG_SH_TG_AI_AR_GL_', 230,  'Switzerland: Ostschweiz (SG/SH/TG/AI/AR/GL)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Nordwestschweiz__AG_BL_BS_', 232,  'Switzerland: Nordwestschweiz (AG/BL/BS)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Jura__JU_NE_', 236,  'Switzerland: Jura (JU/NE)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Graubuenden__GR_', 229,  'Switzerland: Graubuenden (GR)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Switzerland', 'Switzerland__Espace_Mittelland__BE_SO_', 234,  'Switzerland: Espace Mittelland (BE/SO)');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Västra_Götaland', 377,  'Sweden: Västra Götaland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Västmanland',376,  'Sweden: Västmanland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Västernorrland',375,  'Sweden: Västernorrland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Västerbotten',374,  'Sweden: Västerbotten');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Värmland',373,  'Sweden: Värmland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Uppsala',372,  'Sweden: Uppsala');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Stockholm',370,  'Sweden: Stockholm');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Södermanland',371,  'Sweden: Södermanland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Skåne',369,  'Sweden: Skåne');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Östergötland',379,  'Sweden: Östergötland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Örebro',378,  'Sweden: Örebro');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Norrbotten',368,  'Sweden: Norrbotten');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Kronoberg',367,  'Sweden: Kronoberg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Kalmar',366,  'Sweden: Kalmar');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Jönköping',365,  'Sweden: Jönköping');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Jämtland',364,  'Sweden: Jämtland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Halland',363,  'Sweden: Halland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Gotland',361,  'Sweden: Gotland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Gävleborg',362,  'Sweden: Gävleborg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Dalarna',360,  'Sweden: Dalarna');
INSERT INTO GcState (country, id,  code, name) VALUES ('Sweden', 'Sweden__Blekinge',359,  'Sweden: Blekinge');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Región_de_Murcia', 124,  'Spain: Región de Murcia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Principado_de_Asturias', 125,  'Spain: Principado de Asturias');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__País_Vasco', 129,  'Spain: País Vasco');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Melilla',134,  'Spain: Melilla');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__La_Rioja', 131,  'Spain: La Rioja');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Islas_Canarias', 128,  'Spain: Islas Canarias');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Islas_Baleares', 132,  'Spain: Islas Baleares');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Galicia',122,  'Spain: Galicia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Extremadura',120,  'Spain: Extremadura');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Comunidad_Valenciana', 123,  'Spain: Comunidad Valenciana');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Comunidad_Foral_de_Navarra', 126,  'Spain: Comunidad Foral de Navarra');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Comunidad_de_Madrid', 127,  'Spain: Comunidad de Madrid');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Ceuta',133,  'Spain: Ceuta');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Cataluña',121,  'Spain: Cataluña');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Castilla-La_Mancha', 117,  'Spain: Castilla-La Mancha');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Castilla_y_León', 115,  'Spain: Castilla y León');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Cantabria',130,  'Spain: Cantabria');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Aragón',119,  'Spain: Aragón');
INSERT INTO GcState (country, id,  code, name) VALUES ('Spain', 'Spain__Andalucía',116,  'Spain: Andalucía');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Ulsan',302,  'South Korea: Ulsan');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Seoul',296,  'South Korea: Seoul');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Jeolla_nam_do', 308,  'South Korea: Jeolla nam do');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Jeolla_buk_do', 307,  'South Korea: Jeolla buk do');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Jejudo',311,  'South Korea: Jejudo');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Incheon',299,  'South Korea: Incheon');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Gyeongsang_nam_do', 310,  'South Korea: Gyeongsang nam do');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Gyeongsang_buk_do', 309,  'South Korea: Gyeongsang buk do');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Gyeonggido',303,  'South Korea: Gyeonggido');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Gwangju',300,  'South Korea: Gwangju');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Gangwondo',304,  'South Korea: Gangwondo');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Daejeon',301,  'South Korea: Daejeon');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Daegu',298,  'South Korea: Daegu');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Chungcheong_nam_do', 306,  'South Korea: Chungcheong nam do');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Chungcheong_buk_do', 305,  'South Korea: Chungcheong buk do');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Korea', 'South_Korea__Busan',297,  'South Korea: Busan');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Western_Cape', 152,  'South Africa: Western Cape');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Northern_Cape', 154,  'South Africa: Northern Cape');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__North_West', 156,  'South Africa: North West');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Mpumalanga',155,  'South Africa: Mpumalanga');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Limpopo',158,  'South Africa: Limpopo');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Kwazulu_Natal', 157,  'South Africa: Kwazulu Natal');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Gauteng',159,  'South Africa: Gauteng');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Free_State', 160,  'South Africa: Free State');
INSERT INTO GcState (country, id,  code, name) VALUES ('South_Africa', 'South_Africa__Eastern_Cape', 153,  'South Africa: Eastern Cape');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Žilinský_kraj', 294,  'Slovakia: Žilinský kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Trnavský_kraj', 293,  'Slovakia: Trnavský kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Trenčiansky_kraj', 292,  'Slovakia: Trenčiansky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Prešovský_kraj', 291,  'Slovakia: Prešovský kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Nitriansky_kraj', 290,  'Slovakia: Nitriansky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Košický_kraj', 289,  'Slovakia: Košický kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Bratislavský_kraj', 288,  'Slovakia: Bratislavský kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Slovakia', 'Slovakia__Banskobystrický_kraj', 287,  'Slovakia: Banskobystrický kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Viseu',111,  'Portugal: Viseu');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Vila_Real', 112,  'Portugal: Vila Real');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Viana_do_Castelo', 110,  'Portugal: Viana do Castelo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Setúbal',109,  'Portugal: Setúbal');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Santarém',108,  'Portugal: Santarém');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Porto',107,  'Portugal: Porto');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Portalegre',106,  'Portugal: Portalegre');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Lisboa',105,  'Portugal: Lisboa');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Leiria',104,  'Portugal: Leiria');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Guarda',103,  'Portugal: Guarda');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Faro',102,  'Portugal: Faro');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Évora',101,  'Portugal: Évora');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Coimbra',100,  'Portugal: Coimbra');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Castelo_Branco', 99,  'Portugal: Castelo Branco');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Bragança',98,  'Portugal: Bragança');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Braga',97,  'Portugal: Braga');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Beja',96,  'Portugal: Beja');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Aveiro',95,  'Portugal: Aveiro');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Arquipélago_dos_Açores', 114,  'Portugal: Arquipélago dos Açores');
INSERT INTO GcState (country, id,  code, name) VALUES ('Portugal', 'Portugal__Arquipélago_da_Madeira', 113,  'Portugal: Arquipélago da Madeira');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Zachodniopomorskie',411,  'Poland: Zachodniopomorskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Wielkopolskie',410,  'Poland: Wielkopolskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Warmińsko-Mazurskie',409,  'Poland: Warmińsko-Mazurskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Świętokrzyskie',408,  'Poland: Świętokrzyskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Śląskie',407,  'Poland: Śląskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Pomorskie',406,  'Poland: Pomorskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Podlaskie',405,  'Poland: Podlaskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Podkarpackie',404,  'Poland: Podkarpackie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Opolskie',403,  'Poland: Opolskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Mazowieckie',402,  'Poland: Mazowieckie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Małopolskie',401,  'Poland: Małopolskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Lubuskie',399,  'Poland: Lubuskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Lubelskie',398,  'Poland: Lubelskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Łódzkie',400,  'Poland: Łódzkie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Kujawsko_Pomorskie',397,  'Poland: Kujawsko-Pomorskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Poland', 'Poland__Dolnośląskie',396,  'Poland: Dolnośląskie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Vestfold',246,  'Norway: Vestfold');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Vest_Agder',248,  'Norway: Vest-Agder');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Troms',256,  'Norway: Troms');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Telemark',245,  'Norway: Telemark');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Sør_Trøndelag',253,  'Norway: Sør-Trøndelag');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Sogn_og_Fjordane', 251,  'Norway: Sogn og Fjordane');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Rogaland',249,  'Norway: Rogaland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Østfold',239,  'Norway: Østfold');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Oslo',241,  'Norway: Oslo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Oppland',243,  'Norway: Oppland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Nord_Trøndelag',254,  'Norway: Nord-Trøndelag');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Nordland',255,  'Norway: Nordland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Møre_og_Romsdal', 252,  'Norway: Møre og Romsdal');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Hordaland',250,  'Norway: Hordaland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Hedmark',242,  'Norway: Hedmark');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Finnmark',257,  'Norway: Finnmark');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Buskerud',244,  'Norway: Buskerud');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Aust_Agder',247,  'Norway: Aust-Agder');
INSERT INTO GcState (country, id,  code, name) VALUES ('Norway', 'Norway__Akershus',240,  'Norway: Akershus');
INSERT INTO GcState (country, id,  code, name) VALUES ('New_Zealand', 'New_Zealand__South_Island', 86,  'New Zealand: South Island');
INSERT INTO GcState (country, id,  code, name) VALUES ('New_Zealand', 'New_Zealand__North_Island', 82,  'New Zealand: North Island');
INSERT INTO GcState (country, id,  code, name) VALUES ('New_Zealand', 'New_Zealand__Chatham_Islands', 486,  'New Zealand: Chatham Islands');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Zuid_Holland',390,  'Netherlands: Zuid-Holland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Zeeland',391,  'Netherlands: Zeeland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Utrecht',388,  'Netherlands: Utrecht');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Overijssel',386,  'Netherlands: Overijssel');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Noord_Holland',389,  'Netherlands: Noord-Holland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Noord_Brabant',392,  'Netherlands: Noord-Brabant');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Limburg',393,  'Netherlands: Limburg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Groningen',384,  'Netherlands: Groningen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Gelderland',387,  'Netherlands: Gelderland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Friesland',394,  'Netherlands: Friesland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Flevoland',395,  'Netherlands: Flevoland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Netherlands', 'Netherlands__Drenthe',385,  'Netherlands: Drenthe');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Zacatecas',485,  'Mexico: Zacatecas');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Yucatán',484,  'Mexico: Yucatán');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Veracruz',483,  'Mexico: Veracruz');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Tlaxcala',482,  'Mexico: Tlaxcala');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Tamaulipas',481,  'Mexico: Tamaulipas');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Tabasco',480,  'Mexico: Tabasco');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Sonora',479,  'Mexico: Sonora');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Sinaloa',478,  'Mexico: Sinaloa');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__San_Luis_Potosí', 477,  'Mexico: San Luis Potosí');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Quintana_Roo', 476,  'Mexico: Quintana Roo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Querétaro',475,  'Mexico: Querétaro');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Puebla',474,  'Mexico: Puebla');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Oaxaca',473,  'Mexico: Oaxaca');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Nuevo_León', 472,  'Mexico: Nuevo León');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Nayarit',471,  'Mexico: Nayarit');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Morelos',470,  'Mexico: Morelos');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Michoacán',469,  'Mexico: Michoacán');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__México',468,  'Mexico: México');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Jalisco',467,  'Mexico: Jalisco');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Hidalgo',466,  'Mexico: Hidalgo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Guerrero',465,  'Mexico: Guerrero');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Guanajuato',464,  'Mexico: Guanajuato');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Durango',463,  'Mexico: Durango');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Distrito_Federal', 462,  'Mexico: Distrito Federal');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Colima',461,  'Mexico: Colima');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Coahuila',460,  'Mexico: Coahuila');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Chihuahua',459,  'Mexico: Chihuahua');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Chiapas',458,  'Mexico: Chiapas');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Campeche',457,  'Mexico: Campeche');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Baja_California_Sur', 456,  'Mexico: Baja California Sur');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Baja_California', 455,  'Mexico: Baja California');
INSERT INTO GcState (country, id,  code, name) VALUES ('Mexico', 'Mexico__Aguascalientes',454,  'Mexico: Aguascalientes');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Yamanashi',357,  'Japan: Yamanashi');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Yamaguchi',356,  'Japan: Yamaguchi');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Yamagata',355,  'Japan: Yamagata');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Wakayama',354,  'Japan: Wakayama');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Toyama',353,  'Japan: Toyama');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Tottori',352,  'Japan: Tottori');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Tokyo',351,  'Japan: Tokyo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Tokushima',350,  'Japan: Tokushima');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Tochigi',349,  'Japan: Tochigi');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Shizuoka',348,  'Japan: Shizuoka');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Shimane',347,  'Japan: Shimane');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Shiga',346,  'Japan: Shiga');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Saitama',345,  'Japan: Saitama');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Saga',344,  'Japan: Saga');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Osaka',343,  'Japan: Osaka');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Okinawa',342,  'Japan: Okinawa');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Okayama',341,  'Japan: Okayama');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Oita',340,  'Japan: Oita');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Niigata',339,  'Japan: Niigata');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Nara',338,  'Japan: Nara');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Nagasaki',337,  'Japan: Nagasaki');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Nagano',336,  'Japan: Nagano');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Miyazaki',335,  'Japan: Miyazaki');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Miyagi',334,  'Japan: Miyagi');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Mie',333,  'Japan: Mie');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Kyoto',332,  'Japan: Kyoto');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Kumamoto',331,  'Japan: Kumamoto');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Kochi',330,  'Japan: Kochi');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Kanagawa',329,  'Japan: Kanagawa');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Kagoshima',328,  'Japan: Kagoshima');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Kagawa',327,  'Japan: Kagawa');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Iwate',326,  'Japan: Iwate');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Ishikawa',325,  'Japan: Ishikawa');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Ibaraki',324,  'Japan: Ibaraki');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Hyogo',323,  'Japan: Hyogo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Hokkaido',322,  'Japan: Hokkaido');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Hiroshima',321,  'Japan: Hiroshima');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Gunma',320,  'Japan: Gunma');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Gifu',319,  'Japan: Gifu');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Fukushima',318,  'Japan: Fukushima');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Fukuoka',317,  'Japan: Fukuoka');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Fukui',316,  'Japan: Fukui');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Ehime',315,  'Japan: Ehime');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Chiba',314,  'Japan: Chiba');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Aomori',313,  'Japan: Aomori');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Akita',383,  'Japan: Akita');
INSERT INTO GcState (country, id,  code, name) VALUES ('Japan', 'Japan__Aichi',312,  'Japan: Aichi');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Veneto',209,  'Italy: Veneto');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Valle_d_Aosta', 208,  'Italy: Valle d_Aosta');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Umbria',207,  'Italy: Umbria');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Trentino_Alto_Adige_', 206,  'Italy: Trentino_Alto Adige ');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Toscana',205,  'Italy: Toscana');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Sicilia',204,  'Italy: Sicilia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Sardegna',203,  'Italy: Sardegna');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Puglia',202,  'Italy: Puglia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Piemonte',201,  'Italy: Piemonte');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Molise',200,  'Italy: Molise');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Marche',199,  'Italy: Marche');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Lombardia',198,  'Italy: Lombardia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Liguria',197,  'Italy: Liguria');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Lazio',196,  'Italy: Lazio');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Friuli_Venezia_Giulia', 195,  'Italy: Friuli_Venezia Giulia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Emilia_Romagna_', 194,  'Italy: Emilia_Romagna ');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Campania',193,  'Italy: Campania');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Calabria',192,  'Italy: Calabria');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Basilicata',190,  'Italy: Basilicata');
INSERT INTO GcState (country, id,  code, name) VALUES ('Italy', 'Italy__Abruzzo',189,  'Italy: Abruzzo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Ireland', 'Ireland__Ulster',224,  'Ireland: Ulster');
INSERT INTO GcState (country, id,  code, name) VALUES ('Ireland', 'Ireland__Munster',225,  'Ireland: Munster');
INSERT INTO GcState (country, id,  code, name) VALUES ('Ireland', 'Ireland__Leinster',228,  'Ireland: Leinster');
INSERT INTO GcState (country, id,  code, name) VALUES ('Ireland', 'Ireland__Dublin',226,  'Ireland: Dublin');
INSERT INTO GcState (country, id,  code, name) VALUES ('Ireland', 'Ireland__Connacht',227,  'Ireland: Connacht');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Zala',453,  'Hungary: Zala');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Veszprém',452,  'Hungary: Veszprém');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Vas',451,  'Hungary: Vas');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Tolna',450,  'Hungary: Tolna');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Szabolcs-Szatmár-Bereg',449,  'Hungary: Szabolcs-Szatmár-Bereg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Somogy',448,  'Hungary: Somogy');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Pest',447,  'Hungary: Pest');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Nógrád',446,  'Hungary: Nógrád');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Komárom-Esztergom',445,  'Hungary: Komárom-Esztergom');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Jász-Nagykun-Szolnok',444,  'Hungary: Jász-Nagykun-Szolnok');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Heves',443,  'Hungary: Heves');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Hajdú-Bihar',442,  'Hungary: Hajdú-Bihar');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Gyor-Moson-Sopron',441,  'Hungary: Gyor-Moson-Sopron');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Fejér',440,  'Hungary: Fejér');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Csongrád',439,  'Hungary: Csongrád');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Budapest',438,  'Hungary: Budapest');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Borsod-Abaúj-Zemplén',437,  'Hungary: Borsod-Abaúj-Zemplén');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Békés',436,  'Hungary: Békés');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Baranya',435,  'Hungary: Baranya');
INSERT INTO GcState (country, id,  code, name) VALUES ('Hungary', 'Hungary__Bács_Kiskun',434,  'Hungary: Bács-Kiskun');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Thüringen',149,  'Germany: Thüringen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Schleswig_Holstein',148,  'Germany: Schleswig-Holstein');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Sachsen_Anhalt',147,  'Germany: Sachsen-Anhalt');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Sachsen',146,  'Germany: Sachsen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Saarland',145,  'Germany: Saarland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Rheinland_Pfalz',144,  'Germany: Rheinland-Pfalz');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Nordrhein_Westfalen',143,  'Germany: Nordrhein-Westfalen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Niedersachsen',142,  'Germany: Niedersachsen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Mecklenburg_Vorpommern',141,  'Germany: Mecklenburg-Vorpommern');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Hessen',150,  'Germany: Hessen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Hamburg',140,  'Germany: Hamburg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Bremen',139,  'Germany: Bremen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Brandenburg',138,  'Germany: Brandenburg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Berlin',137,  'Germany: Berlin');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Bayern',136,  'Germany: Bayern');
INSERT INTO GcState (country, id,  code, name) VALUES ('Germany', 'Germany__Baden_Württemberg',135,  'Germany: Baden-Württemberg');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Rhône_Alpes',432,  'France: Rhône-Alpes');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Provence_Alpes_Côte_d_Azur', 431,  'France: Provence-Alpes-Côte d_Azur');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Poitou_Charentes',430,  'France: Poitou-Charentes');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Picardie',429,  'France: Picardie');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Pays_de_la_Loire', 428,  'France: Pays de la Loire');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Nord_Pas_de_Calais',427,  'France: Nord-Pas-de-Calais');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Midi_Pyrénées',426,  'France: Midi-Pyrénées');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Lorraine',425,  'France: Lorraine');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Limousin',424,  'France: Limousin');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Languedoc_Roussillon',423,  'France: Languedoc-Roussillon');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Île_de_France',422,  'France: Île-de-France');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Haute_Normandie',421,  'France: Haute-Normandie');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Franche_Comté',420,  'France: Franche-Comté');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Corse',419,  'France: Corse');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Champagne_Ardenne',418,  'France: Champagne-Ardenne');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Centre',417,  'France: Centre');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Bretagne',416,  'France: Bretagne');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Bourgogne',415,  'France: Bourgogne');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Basse_Normandie',414,  'France: Basse-Normandie');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Auvergne',413,  'France: Auvergne');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Aquitaine',412,  'France: Aquitaine');
INSERT INTO GcState (country, id,  code, name) VALUES ('France', 'France__Alsace',433,  'France: Alsace');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Zlinsky_kraj', 285,  'Czech Republic: Zlinsky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Ustecky_kraj', 283,  'Czech Republic: Ustecky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Stredocesky_kraj', 282,  'Czech Republic: Stredocesky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Plzensky_kraj', 281,  'Czech Republic: Plzensky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Pardubicky_kraj', 280,  'Czech Republic: Pardubicky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Olomoucky_kraj', 278,  'Czech Republic: Olomoucky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Moravskoslezsky_kraj', 279,  'Czech Republic: Moravskoslezsky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Liberecky_kraj', 277,  'Czech Republic: Liberecky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Kralovehradecky_kraj', 275,  'Czech Republic: Kralovehradecky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Kraj_Vysocina', 284,  'Czech Republic: Kraj Vysocina');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Karlovarsky_kraj', 276,  'Czech Republic: Karlovarsky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Jihomoravsky_kraj', 273,  'Czech Republic: Jihomoravsky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Jihocesky_kraj', 274,  'Czech Republic: Jihocesky kraj');
INSERT INTO GcState (country, id,  code, name) VALUES ('Czech_Republic', 'Czech_Republic__Hlavni_mesto_Praha', 286,  'Czech Republic: Hlavni mesto Praha');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Yukon_Territory', 74,  'Canada: Yukon Territory');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Saskatchewan',71,  'Canada: Saskatchewan');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Quebec',62,  'Canada: Quebec');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Prince_Edward_Island', 70,  'Canada: Prince Edward Island');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Ontario',69,  'Canada: Ontario');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Nunavut',73,  'Canada: Nunavut');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Nova_Scotia', 68,  'Canada: Nova Scotia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Northwest_Territories', 72,  'Canada: Northwest Territories');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Newfoundland_and_Labrador', 67,  'Canada: Newfoundland and Labrador');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__New_Brunswick', 66,  'Canada: New Brunswick');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Manitoba',65,  'Canada: Manitoba');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__British_Columbia', 64,  'Canada: British Columbia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Canada', 'Canada__Alberta',63,  'Canada: Alberta');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Tocantins',188,  'Brazil: Tocantins');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Sergipe',187,  'Brazil: Sergipe');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__São_Paulo', 186,  'Brazil: São Paulo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Santa_Catarina', 185,  'Brazil: Santa Catarina');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Roraima',184,  'Brazil: Roraima');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Rondônia',183,  'Brazil: Rondônia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Rio_Grande_do_Sul', 182,  'Brazil: Rio Grande do Sul');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Rio_Grande_do_Norte', 181,  'Brazil: Rio Grande do Norte');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Rio_de_Janeiro', 180,  'Brazil: Rio de Janeiro');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Piauí',179,  'Brazil: Piauí');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Pernambuco',178,  'Brazil: Pernambuco');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Paraná',177,  'Brazil: Paraná');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Paraíba',176,  'Brazil: Paraíba');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Pará',175,  'Brazil: Pará');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Minas_Gerais', 174,  'Brazil: Minas Gerais');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Mato_Grosso_do_Sul', 173,  'Brazil: Mato Grosso do Sul');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Mato_Grosso', 172,  'Brazil: Mato Grosso');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Maranhão',171,  'Brazil: Maranhão');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Goiás',170,  'Brazil: Goiás');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Espírito_Santo', 169,  'Brazil: Espírito Santo');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Distrito_Federal', 168,  'Brazil: Distrito Federal');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Ceará',167,  'Brazil: Ceará');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Bahia',166,  'Brazil: Bahia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Amazonas',165,  'Brazil: Amazonas');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Amapá',164,  'Brazil: Amapá');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Alagoas',163,  'Brazil: Alagoas');
INSERT INTO GcState (country, id,  code, name) VALUES ('Brazil', 'Brazil__Acre',162,  'Brazil: Acre');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__West_Vlaanderen',92,  'Belgium: West-Vlaanderen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Vlaams_Brabant',78,  'Belgium: Vlaams-Brabant');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Oost_Vlaanderen',76,  'Belgium: Oost-Vlaanderen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Namur',81,  'Belgium: Namur');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Luxembourg',90,  'Belgium: Luxembourg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Limburg',89,  'Belgium: Limburg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Liège',80,  'Belgium: Liège');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Hainaut',88,  'Belgium: Hainaut');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Brussels',93,  'Belgium: Brussels');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Brabant_wallon', 91,  'Belgium: Brabant wallon');
INSERT INTO GcState (country, id,  code, name) VALUES ('Belgium', 'Belgium__Antwerpen',87,  'Belgium: Antwerpen');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Wien',295,  'Austria: Wien');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Vorarlberg',265,  'Austria: Vorarlberg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Tirol',264,  'Austria: Tirol');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Steiermark',263,  'Austria: Steiermark');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Salzburg',262,  'Austria: Salzburg');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Oberösterreich',261,  'Austria: Oberösterreich');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Niederösterreich',260,  'Austria: Niederösterreich');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Kärnten',259,  'Austria: Kärnten');
INSERT INTO GcState (country, id,  code, name) VALUES ('Austria', 'Austria__Burgenland',258,  'Austria: Burgenland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__Western_Australia', 56,  'Australia: Western Australia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__Victoria',53,  'Australia: Victoria');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__Tasmania',57,  'Australia: Tasmania');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__South_Australia', 55,  'Australia: South Australia');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__Queensland',54,  'Australia: Queensland');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__Northern_Territory', 58,  'Australia: Northern Territory');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__New_South_Wales', 52,  'Australia: New South Wales');
INSERT INTO GcState (country, id,  code, name) VALUES ('Australia', 'Australia__Australian_Capital_Territory', 59,  'Australia: Australian Capital Territory');

alter table gccache add CONSTRAINT fk_gccache_state FOREIGN KEY (state) REFERENCES gcstate(id);
