/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.ui;

import io.ultreia.gc.service.GcArcheoLogsComputationProgressMonitor;
import javax.swing.JProgressBar;

public class ProgressPanelUI
extends JProgressBar
implements GcArcheoLogsComputationProgressMonitor {
    public static final String PROPERTY_ARCHEO_LOG = "archeoLog";

    public ProgressPanelUI() {
        this.setBorderPainted(true);
        this.setStringPainted(true);
    }

    public void init(int nbSteps) {
        this.setMinimum(0);
        this.setMaximum(nbSteps);
        this.setValue(0);
    }

    @Override
    public void increment(String stepMessage) {
        this.setValue(this.getValue() + 1);
        float progression = (float)this.getValue() / (float)this.getMaximum() * 100.0f;
        this.setString(String.format("%s (%d%%)", stepMessage, (int)progression));
    }

    @Override
    public void onPointsAdded(GcArcheoLogsComputationProgressMonitor.GcArcheoLogEvent archeoLogEvent) {
        this.firePropertyChange(PROPERTY_ARCHEO_LOG, null, archeoLogEvent);
    }
}

