/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.ui;

import io.ultreia.gc.config.GcConfig;
import io.ultreia.gc.service.GcAuthService;
import io.ultreia.gc.service.GcServiceContext;
import io.ultreia.gc.ui.AfterLoginUI;
import io.ultreia.gc.ui.ContentPanelUI;
import io.ultreia.gc.ui.GcApplicationContextSupport;
import io.ultreia.gc.ui.LoginPanelUI;
import io.ultreia.gc.ui.ProgressPanelUI;
import io.ultreia.gc.ui.actions.LogOutAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jdesktop.swingx.JXLoginPane;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public abstract class GcApplicationUISupport<C extends GcConfig, Context extends GcApplicationContextSupport<C>, M, Content extends ContentPanelUI<C, Context, M>>
implements AfterLoginUI<C, Context> {
    private final Context applicationContext;
    private final JFrame frame;
    private final ProgressPanelUI progressPanel;
    private final GcAuthService authService;
    private final Content contentPanel;
    private final M model;

    protected GcApplicationUISupport(Context applicationContext, M model, String title) {
        this.applicationContext = applicationContext;
        this.authService = new GcAuthService();
        this.authService.setServiceContext((GcServiceContext)applicationContext);
        this.model = model;
        this.progressPanel = new ProgressPanelUI();
        Object config = ((GcApplicationContextSupport)applicationContext).getConfig();
        this.frame = new JFrame(String.format("%s - v%s (build %s : %s)", title, config.getBuildVersion(), config.getBuildDate(), config.getBuildNumber()));
        this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLayout(new BorderLayout());
        this.frame.addWindowListener(new WindowAdapter((GcApplicationContextSupport)applicationContext){
            final /* synthetic */ GcApplicationContextSupport val$applicationContext;
            {
                this.val$applicationContext = gcApplicationContextSupport;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.val$applicationContext.close();
            }
        });
        this.contentPanel = this.createContentPanel(model);
        ((ContentPanelUI)this.contentPanel).installActions(applicationContext, model);
        this.frame.add((Component)this.contentPanel, "Center");
        this.frame.setMinimumSize(new Dimension(1280, 600));
        this.frame.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        this.frame.setVisible(true);
        this.frame.add((Component)this.progressPanel, "South");
    }

    public final JFrame getFrame() {
        return this.frame;
    }

    public final M getModel() {
        return this.model;
    }

    protected abstract void afterLogOut();

    protected abstract Content createContentPanel(M var1);

    public final void logIn(boolean autoLogin) {
        LoginPanelUI loginPanel = LoginPanelUI.create(this, ((GcApplicationContextSupport)this.applicationContext).getConfig(), this.authService);
        JXLoginPane.JXLoginDialog loginDialog = new JXLoginPane.JXLoginDialog((Frame)this.frame, (JXLoginPane)loginPanel);
        loginPanel.init(autoLogin);
        SwingUtil.center((Component)this.frame, (Component)loginDialog);
        loginDialog.setVisible(true);
    }

    public final Content getContentPanel() {
        return this.contentPanel;
    }

    public final ProgressPanelUI getProgressPanel() {
        return this.progressPanel;
    }

    @Override
    public final void setBusy(boolean b) {
        ((ContentPanelUI)this.getContentPanel()).setBusy(b);
    }

    @Override
    public void afterLogin(String authId) {
        if (((GcServiceContext)this.applicationContext).getAuthId().isPresent()) {
            this.authService.logout();
        }
        ((GcServiceContext)this.applicationContext).setAuthId(authId);
        ((ContentPanelUI)this.getContentPanel()).getLogOut().setText("Log out");
        ((ContentPanelUI)this.getContentPanel()).getLogOut().setIcon(LogOutAction.ICON_LOGOUT);
    }

    @Override
    public final void logOut() {
        try {
            this.authService.logout();
            ((GcServiceContext)this.applicationContext).setAuthId(null);
        }
        finally {
            ((ContentPanelUI)this.getContentPanel()).getLogOut().setText("Log in");
            ((ContentPanelUI)this.getContentPanel()).getLogOut().setIcon(LogOutAction.ICON_LOGIN);
            this.afterLogOut();
            this.logIn(false);
        }
    }

    @Override
    public final void quit() {
        this.frame.dispose();
    }

    @Override
    public final Context getApplicationContext() {
        return this.applicationContext;
    }
}

