/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.session;

import io.ultreia.gc.http.GcExecuteRequestException;
import io.ultreia.gc.http.GcLoginException;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.http.GcResponseBuilder;
import io.ultreia.gc.model.GcTrackable;
import io.ultreia.gc.service.GcServiceContext;
import io.ultreia.gc.service.GcTrackableService;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;

public class GcSession
implements Closeable {
    private static final Log log = LogFactory.getLog(GcSession.class);
    private static final Map<String, String> HEADERS = new LinkedHashMap<String, String>();
    private final GcResponseBuilder responseBuilder = GcResponseBuilder.create();
    private final String username;
    private final String id;
    private String authToken;

    public GcRequestBuilder forGet(String baseUrl) {
        return GcRequestBuilder.forGet(baseUrl, this::getAuthToken).addHeaders(HEADERS);
    }

    public GcRequestBuilder forPost(String baseUrl) {
        return GcRequestBuilder.forPost(baseUrl, this::getAuthToken).addHeaders(HEADERS);
    }

    public GcRequestBuilder forDelete(String baseUrl) {
        return GcRequestBuilder.forDelete(baseUrl, this::getAuthToken).addHeaders(HEADERS);
    }

    public GcRequestBuilder forPatch(String baseUrl) {
        return GcRequestBuilder.forPatch(baseUrl, this::getAuthToken).addHeaders(HEADERS);
    }

    GcSession(String username, String password) {
        this.username = username;
        this.id = UUID.randomUUID().toString();
        GcRequest request = this.forGet("https://www.geocaching.com/account/login").build();
        GcResponse build = this.executeRequest(request);
        Document doc = build.getResponseAsHtml();
        String requestVerificationToken = doc.select("input[name='__RequestVerificationToken'][type='hidden']").attr("value");
        log.debug((Object)("User requestVerificationToken: " + requestVerificationToken));
        GcRequest request1 = this.forPost("https://www.geocaching.com/account/login").addHeaders(HEADERS).addParameter("UserName", username).addParameter("Password", password).addParameter("__RequestVerificationToken", requestVerificationToken).build();
        GcResponse build1 = this.executeRequest(request1);
        log.debug((Object)("status code: " + build1.getStatusCode()));
        log.debug((Object)("headers: " + Arrays.toString(build1.getResponseHeaders())));
        if (build1.getStatusCode() != 302) {
            throw new GcLoginException(build1.getResponseAsString());
        }
        log.info((Object)"Log in.");
    }

    public Set<GcTrackable> getTrackables() {
        GcTrackableService service = new GcTrackableService();
        service.setServiceContext(GcServiceContext.create(this.getId()));
        return service.getTrackables();
    }

    public String getAuthToken() {
        if (this.authToken == null) {
            GcRequest request = this.forGet("https://www.geocaching.com/account/oauth/token").build();
            GcResponse build = this.executeRequest(request);
            Map<String, Object> responseAsJson = build.getResponseAsJson();
            this.authToken = responseAsJson.get("token_type").toString() + " " + responseAsJson.get("access_token").toString();
        }
        return this.authToken;
    }

    public GcResponse executeRequest(GcRequest request) {
        try {
            return this.responseBuilder.executeRequest(request);
        }
        catch (IOException e) {
            throw new GcExecuteRequestException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.responseBuilder.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcSession gcSession = (GcSession)o;
        return Objects.equals(this.id, gcSession.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    static {
        HEADERS.put("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:48.0) Gecko/20100101 Firefox/48.0");
        HEADERS.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HEADERS.put("Accept-Language", "fr-fr,en-us;q=0.7,en;q=0.3");
        HEADERS.put("DNT", "1");
        HEADERS.put("Connection", "keep-alive");
    }
}

