/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.service.GcServiceSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GpxService
extends GcServiceSupport {
    public Set<String> getGcNames(File gpxFile) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (BufferedReader read = Files.newBufferedReader(gpxFile.toPath());){
            String line = null;
            while ((line = read.readLine()) != null) {
                int i = line.indexOf("<name>");
                if (i <= -1 || line.contains("Project")) continue;
                String gcName = line.substring(i + "<name>".length(), line.indexOf("</name>", i));
                result.add(gcName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public List<GcCache> getCaches(File gpxFile) {
        LinkedList<GcCache> result = new LinkedList<GcCache>();
        String cleanXml = GpxService.flatXmlNamespaces(gpxFile.toPath());
        Document document = Jsoup.parse((String)cleanXml);
        for (Element wpt : document.select("wpt")) {
            GcCache gcCache = new GcCache();
            gcCache.setLat(wpt.attr("lat"));
            gcCache.setLon(wpt.attr("lon"));
            gcCache.setGcName(wpt.select("name").text());
            gcCache.setDesc(wpt.select("desc").text());
            gcCache.setUrl(wpt.select("url").text());
            gcCache.setUrlname(wpt.select("urlname").text());
            gcCache.setSym(wpt.select("sym").text());
            gcCache.setTime(wpt.select("time").text());
            gcCache.setGcType(wpt.select("type").text().split("\\|")[1]);
            Elements groundspeak = wpt.select("groundspeak_cache");
            gcCache.setAvailable("True".equals(groundspeak.attr("available")));
            gcCache.setArchived("True".equals(groundspeak.attr("archived")));
            gcCache.setGcId(groundspeak.attr("id"));
            gcCache.setPlacedby(groundspeak.select("groundspeak_placed_by").text());
            gcCache.setOwner(groundspeak.select("groundspeak_owner").text());
            gcCache.setOwnerId(groundspeak.select("groundspeak_owner").attr("id"));
            gcCache.setContainer(groundspeak.select("groundspeak_container").text());
            gcCache.setDifficulty(Float.valueOf(groundspeak.select("groundspeak_difficulty").text()).floatValue());
            gcCache.setTerrain(Float.valueOf(groundspeak.select("groundspeak_terrain").text()).floatValue());
            gcCache.setCountry(groundspeak.select("groundspeak_country").text());
            gcCache.setState(groundspeak.select("groundspeak_state").text());
            gcCache.setShortDesc(groundspeak.select("groundspeak_short_description").text());
            gcCache.setShortDescHtml("True".equals(groundspeak.select("groundspeak_short_description").attr("html")));
            gcCache.setLongDesc(groundspeak.select("groundspeak_long_description").text());
            gcCache.setLongDescHtml("True".equals(groundspeak.select("groundspeak_long_description").attr("html")));
            gcCache.setHint(groundspeak.select("groundspeak_encoded_hints").text());
            Elements gsak_wptExtensions = wpt.select("gsak_wptExtension");
            if (gsak_wptExtensions.size() == 1) {
                String gsak_favPoints;
                String gsak_note;
                String gsak_oldLon;
                Element gsak = (Element)gsak_wptExtensions.get(0);
                gcCache.setHasGsakExt(true);
                String gsak_oldLat = gsak.select("gsak_LatBeforeCorrect").text();
                if (!gsak_oldLat.isEmpty()) {
                    gcCache.setOldLat(gsak_oldLat);
                }
                if (!(gsak_oldLon = gsak.select("gsak_LonBeforeCorrect").text()).isEmpty()) {
                    gcCache.setOldLon(gsak_oldLon);
                }
                if (!(gsak_note = gsak.select("gsak_GcNote").text()).isEmpty()) {
                    gcCache.setUserNote(gsak_note);
                }
                if (!(gsak_favPoints = gsak.select("gsak_FavPoints").text()).isEmpty()) {
                    gcCache.setFavPoints(Integer.valueOf(gsak_favPoints));
                }
                gcCache.setPremium("1".equals(gsak.select("gsak_IsPremium").text()));
            }
            result.add(gcCache);
        }
        return result;
    }

    public static void main(String ... args) throws IOException {
        Path path = Paths.get("/home/tchemit/.gc/finish-st-seb.gpx", new String[0]);
        List<GcCache> caches = new GpxService().getCaches(path.toFile());
        System.out.printf(String.format("Found %d cache(s).", caches.size()), new Object[0]);
    }

    private static String flatXmlNamespaces(Path path) {
        StringBuilder cleanXmlBuilder = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                String cleanLine = line.replaceAll("<(\\w+):(\\w+)>", "<$1_$2>").replaceAll("<(\\w+):(\\w+)\\s([^>]+)>", "<$1_$2 $3>").replaceAll("</(\\w+):(\\w+)>", "</$1_$2>");
                cleanXmlBuilder.append(cleanLine).append('\n');
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cleanXmlBuilder.toString();
    }
}

